/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.loader.sax;

import org.modelio.vbasic.log.Log;
import org.modelio.vstore.exml.local.loader.sax.ATTState;
import org.modelio.vstore.exml.local.loader.sax.AbstractState;
import org.modelio.vstore.exml.local.loader.sax.DataModel;
import org.modelio.vstore.exml.local.loader.sax.DocumentState;
import org.modelio.vstore.exml.local.loader.sax.EXTDEPState;
import org.modelio.vstore.exml.local.loader.sax.IObjectDataModel;
import org.modelio.vstore.exml.local.loader.sax.OBJECTState;
import org.modelio.vstore.exml.local.loader.sax.REFOBJState;
import org.modelio.vstore.exml.local.loader.sax.RelationState;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DocumentContentHandler
extends DefaultHandler {
    private boolean errorEncountered;
    private AbstractState currentState;
    private final OBJECTState objectState = new OBJECTState();
    private final REFOBJState refObjState;
    private final RelationState relationState = new RelationState();
    private final EXTDEPState extDepState = new EXTDEPState();
    private final DocumentState documentState;
    private Locator locator;
    private final DataModel dataModel;
    private final AbstractState attState;

    public DocumentContentHandler(DataModel dataModel) {
        this.refObjState = new REFOBJState();
        this.attState = new ATTState();
        this.documentState = new DocumentState();
        this.documentState.setStateHandler(this);
        this.relationState.setStateHandler(this);
        this.extDepState.setStateHandler(this);
        this.objectState.setStateHandler(this);
        this.refObjState.setStateHandler(this);
        this.attState.setStateHandler(this);
        this.currentState = this.documentState;
        this.errorEncountered = false;
        this.dataModel = dataModel;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            this.currentState.characters(chars, start, length);
        }
        catch (RuntimeException e) {
            throw this.parseRuntimeException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.currentState.endElement(uri, localName, qName);
        }
        catch (RuntimeException e) {
            throw this.parseRuntimeException(e);
        }
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        throw exc;
    }

    @Override
    public void fatalError(SAXParseException exc) throws SAXException {
        throw exc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
        this.dataModel.setDocumentLocator(aLocator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.currentState.startElement(uri, localName, qName, atts);
        }
        catch (RuntimeException e) {
            throw this.parseRuntimeException(e);
        }
    }

    @Override
    public void warning(SAXParseException exc) {
        Log.warning((Throwable)exc);
    }

    void enterAttState() {
        this.currentState = this.attState;
    }

    void enterEXTDEPState() {
        this.currentState = this.extDepState;
        this.dataModel.getCurrent().setCurrentState(this.currentState);
    }

    void enterOBJECTState() {
        this.currentState = this.objectState;
    }

    void enterREFOBJState() {
        this.currentState = this.refObjState;
    }

    void enterRelationState() {
        this.currentState = this.relationState;
        this.dataModel.getCurrent().setCurrentState(this.currentState);
    }

    DataModel getDataModel() {
        return this.dataModel;
    }

    boolean hasEncounteredError() {
        return this.errorEncountered;
    }

    void popOBJECTState() {
        IObjectDataModel oldModel = this.dataModel.pop();
        IObjectDataModel currentModel = this.dataModel.getCurrent();
        oldModel.finishDependenciesLoading();
        if (currentModel == null) {
            this.enterDocumentState();
        } else {
            this.currentState = currentModel.getCurrentState();
            currentModel.addToDep(oldModel.getObject());
        }
    }

    public void reset() {
        this.errorEncountered = false;
        this.enterDocumentState();
    }

    void setErrorEncountered() {
        this.errorEncountered = true;
    }

    void throwError(String msg) throws SAXException {
        this.error(new SAXParseException(msg, this.getLocator()));
    }

    void throwFatalError(String msg) throws SAXException {
        this.fatalError(new SAXParseException(msg, this.getLocator()));
    }

    private void enterDocumentState() {
        this.currentState = this.documentState;
    }

    private SAXParseException parseRuntimeException(RuntimeException e) {
        return new SAXParseException(e.toString(), this.getLocator(), e);
    }
}

