/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.loader.sax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.DependencyNotFoundException;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.local.loader.sax.AbstractState;
import org.modelio.vstore.exml.local.loader.sax.DataModel;
import org.modelio.vstore.exml.local.loader.sax.IDependencyContentHook;
import org.modelio.vstore.exml.local.loader.sax.IObjectDataModel;

final class ObjectDataModel
implements IObjectDataModel {
    private final boolean isNew;
    private boolean currentDepTargetsInSameRepository;
    private final Collection<SmDependency> readDeps = new ArrayList<SmDependency>();
    private final SmObjectImpl current;
    private SmDependency currentDep;
    private List<SmObjectImpl> currentDepContent = DataModel.EMPTY_DEP;
    private AbstractState currentstate;
    private final DataModel dataModel;

    @Override
    public void finishDependenciesLoading() {
        block4: {
            IDependencyContentHook depHook;
            IModelLoader theModelLoader;
            block5: {
                if (this.dataModel.getVersion() < 3) break block4;
                theModelLoader = this.dataModel.modelLoader;
                depHook = this.dataModel.depContentHook;
                if (!this.isNew) break block5;
                if (depHook == null) break block4;
                for (IDependencyContentHook.Content content : depHook.getContent(this.current)) {
                    if (this.readDeps.contains(content.getDep())) continue;
                    theModelLoader.loadDependency(this.current, content.getDep(), content.getContent());
                }
                break block4;
            }
            for (SmDependency smDependency : ExmlUtils.getExternalisableDeps(this.current)) {
                if (this.readDeps.contains(smDependency)) continue;
                if (depHook == null) {
                    theModelLoader.loadDependency(this.current, smDependency, DataModel.EMPTY_DEP);
                    continue;
                }
                List<SmObjectImpl> moreContent = depHook.getContent(this.current, smDependency);
                if (moreContent == null) {
                    moreContent = DataModel.EMPTY_DEP;
                }
                theModelLoader.loadDependency(this.current, smDependency, moreContent);
            }
        }
    }

    @Override
    public void setCurrentState(AbstractState currentstate) {
        this.currentstate = currentstate;
    }

    @Override
    public AbstractState getCurrentState() {
        return this.currentstate;
    }

    @Override
    public void updateCurrentDependency() {
        if (this.currentDep != null) {
            List<SmObjectImpl> moreContent;
            if (this.dataModel.depContentHook != null && (moreContent = this.dataModel.depContentHook.getContent(this.current, this.currentDep)) != null) {
                if (this.currentDepContent == DataModel.EMPTY_DEP) {
                    this.currentDepContent = moreContent;
                } else {
                    this.currentDepContent.addAll(moreContent);
                }
            }
            this.dataModel.modelLoader.loadDependency(this.current, this.currentDep, this.currentDepContent);
            this.readDeps.add(this.currentDep);
        }
        this.currentDepContent = DataModel.EMPTY_DEP;
        this.currentDep = null;
    }

    @Override
    public void beginDependency(String depName) throws DependencyNotFoundException {
        this.currentDep = this.findDependencyDef(this.current, depName);
        if (this.currentDep == null) {
            throw new DependencyNotFoundException("'" + depName + "' dependency not found for " + String.valueOf(this.current));
        }
        this.currentDepTargetsInSameRepository = ExmlUtils.areTargetsAlwaysInSameRepository(this.currentDep);
    }

    @Override
    public void addRefToDep(ObjIdName ref) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        Objects.requireNonNull(ref);
        if (this.currentDep == null) {
            throw new IllegalStateException("No current dependency");
        }
        SmObjectImpl obj = this.findDepRef(ref);
        if (obj == null) {
            return;
        }
        this.addToDep(obj);
    }

    private SmObjectImpl findDepRef(ObjIdName ref) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        ILoadHelper loadHelper = this.dataModel.loadHelper;
        SmObjectImpl obj = loadHelper.getLoadedObject(ref.toObjId());
        if (obj != null) {
            return obj;
        }
        if (this.currentDepTargetsInSameRepository) {
            return loadHelper.createStubObject(this.dataModel.modelLoader, ref, true);
        }
        return loadHelper.getRefObject(this.dataModel.modelLoader, ref);
    }

    @Override
    public void addToDep(SmObjectImpl obj) {
        assert (obj != null);
        assert (this.currentDep != null);
        if (this.currentDepContent == DataModel.EMPTY_DEP) {
            this.currentDepContent = new ArrayList<SmObjectImpl>(3);
        }
        this.currentDepContent.add(obj);
    }

    private SmDependency findDependencyDef(SmObjectImpl object, String relation) {
        SmDependency smdep = object.getClassOf().getDependencyDef(relation);
        if (smdep == null) {
            String rel2 = relation.substring(0, 1).toLowerCase(Locale.ROOT) + relation.substring(1);
            smdep = object.getClassOf().getDependencyDef(rel2);
        }
        return smdep;
    }

    @Override
    public SmObjectImpl getObject() {
        return this.current;
    }

    public String toString() {
        return String.valueOf(this.current) + ", dep=" + String.valueOf(this.currentDep) + " , size=" + this.currentDepContent.size() + ", state=" + String.valueOf(this.currentstate);
    }

    public ObjectDataModel(DataModel dataModel, SmObjectImpl obj, boolean isNew) {
        this.dataModel = dataModel;
        this.current = obj;
        this.isNew = isNew;
    }
}

