/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.loader.sax;

import java.io.IOException;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.local.loader.IExmlLoader;
import org.modelio.vstore.exml.local.loader.sax.DataModel;
import org.modelio.vstore.exml.local.loader.sax.DocumentContentHandler;
import org.modelio.vstore.exml.local.loader.sax.IDependencyContentHook;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxExmlLoader
implements IExmlLoader {
    private final DocumentContentHandler defaultHandler;
    private final XMLReader xmlReader;
    private final DataModel dataModel;
    private final AtomicBoolean loadInProgress = new AtomicBoolean(false);

    public SaxExmlLoader(ILoadHelper loadHelper) {
        this.dataModel = new DataModel(loadHelper);
        this.defaultHandler = new DocumentContentHandler(this.dataModel);
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxFactory.newSAXParser();
            this.xmlReader = parser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.xmlReader.setContentHandler(this.defaultHandler);
            this.xmlReader.setErrorHandler(this.defaultHandler);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceConfigurationError(e.getLocalizedMessage(), e);
        }
        catch (SAXException e) {
            throw new ServiceConfigurationError(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public SmObjectImpl load(InputSource is, IModelLoader loader) throws IOException, DuplicateObjectException {
        if (!this.loadInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " Reentrant call not allowed.");
        }
        try {
            this.dataModel.reset();
            this.defaultHandler.reset();
            this.dataModel.setModelLoader(loader);
            this.xmlReader.parse(is);
            SmObjectImpl smObjectImpl = this.dataModel.getRootObject();
            return smObjectImpl;
        }
        catch (SAXParseException e) {
            String msg = e.getPublicId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getLocalizedMessage();
            throw new IOException(msg, e);
        }
        catch (SAXException e) {
            String msg = is.getPublicId() + ": " + e.getLocalizedMessage();
            throw new IOException(msg, e);
        }
        catch (IOException e) {
            String msg = is.getPublicId() + ": " + FileUtils.getLocalizedMessage((IOException)e);
            throw new IOException(msg, e);
        }
        catch (Error | RuntimeException e) {
            e.addSuppressed(new Throwable("Error occurred while reading '" + is.getPublicId() + "'"));
            throw e;
        }
        finally {
            this.loadInProgress.set(false);
            this.dataModel.setModelLoader(null);
        }
    }

    protected final void setDependencyContentHook(IDependencyContentHook hook) {
        this.dataModel.setDependencyContentHook(hook);
    }
}

