/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.save;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.local.save.ElementDependencies;

class DependencyAnalyzer {
    DependencyAnalyzer() {
    }

    public ElementDependencies getDependentObjects(SmObjectImpl object) {
        ElementDependencies deps = new ElementDependencies();
        deps.parentNode = ExmlUtils.getParentCmsNode((MObject)object);
        this.doGetDependentObjects(object, deps, new HashSet<SmObjectImpl>());
        deps.compNodes.remove(object);
        deps.refNodes.remove(object);
        deps.refDeps.remove(object);
        return deps;
    }

    private void doGetDependentObjects(SmObjectImpl object, ElementDependencies deps, Collection<SmObjectImpl> recursionContext) {
        if (recursionContext.contains(object)) {
            return;
        }
        recursionContext.add(object);
        List<SmDependency> dependencies = ExmlUtils.getExternalisableDeps(object);
        for (SmDependency dep : dependencies) {
            List depTargets = object.getDepValList(dep);
            if (dep.isComposition()) {
                for (SmObjectImpl target : depTargets) {
                    this.processComponent(object, deps, recursionContext, target);
                }
                continue;
            }
            if (dep.isSharedComposition()) {
                for (SmObjectImpl target : depTargets) {
                    if (ExmlUtils.isComposition(object, dep, target)) {
                        this.processComponent(object, deps, recursionContext, target);
                        continue;
                    }
                    this.processReference(object, deps, target);
                }
                continue;
            }
            for (SmObjectImpl target : depTargets) {
                this.processReference(object, deps, target);
            }
        }
        recursionContext.remove(object);
    }

    private void processComponent(SmObjectImpl object, ElementDependencies deps, Collection<SmObjectImpl> recursionContext, SmObjectImpl target) {
        if (!ExmlUtils.sameRepository(object, target)) {
            deps.extDeps.add((MObject)target);
        } else if (target.getClassOf().isCmsNode()) {
            deps.compNodes.add((MObject)target);
        } else {
            this.doGetDependentObjects(target, deps, recursionContext);
        }
    }

    private void processReference(SmObjectImpl object, ElementDependencies deps, SmObjectImpl target) {
        if (!ExmlUtils.sameRepository(object, target)) {
            deps.extDeps.add((MObject)target);
        } else if (target.getClassOf().isCmsNode()) {
            deps.refNodes.add((MObject)target);
        } else {
            deps.refDeps.add((MObject)target);
        }
    }
}

