/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.save;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.xml.CloseableXMLStreamWriter;
import org.modelio.vcore.session.api.repository.StorageErrorSupport;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmLiveId;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.local.save.DependencyAnalyzer;
import org.modelio.vstore.exml.local.save.ElementDependencies;
import org.modelio.vstore.exml.plugin.VStoreExml;

public class ExmlSaver
implements ExmlTags {
    private XMLStreamWriter out;
    private final StorageErrorSupport errSupport;

    public ExmlSaver(StorageErrorSupport errSupport) {
        this.errSupport = errSupport;
    }

    private static SmObjectImpl getParentExt(SmObjectImpl object) {
        IRepositoryObject handler;
        if (object.getMClass().isCmsNode()) {
            SmObjectImpl parent = object.getCompositionOwner();
            if (parent == null) {
                return null;
            }
            handler = parent.getRepositoryObject();
        } else {
            handler = object.getRepositoryObject();
        }
        ExmlStorageHandler exmlHandler = (ExmlStorageHandler)handler;
        SmObjectImpl cmsNode = exmlHandler.getCmsNode();
        return cmsNode;
    }

    public void externalize(SmObjectImpl object, OutputStream os) throws IOException {
        try {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (CloseableXMLStreamWriter closeableWriter = new CloseableXMLStreamWriter(os, true);){
                    this.out = closeableWriter.getW();
                    this.out.writeStartDocument();
                    this.out.writeComment("GENERATED FILE, PLEASE DO NOT EDIT!!!");
                    this.dumpEXT(object);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FactoryConfigurationError e) {
                throw new IOException(e);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.out = null;
        }
    }

    private void reportCompToForeign(SmObjectImpl object, SmDependency dep, SmObjectImpl t) {
        Object[] args = new Object[]{object, t, dep, object.getRepositoryObject(), t.getRepositoryObject(), object.getRepositoryObject().getRepositoryId(), t.getRepositoryObject().getRepositoryId(), object.getStatusLazy(), t.getStatusLazy(), SmLiveId.getRid((long)object.getLiveId()), SmLiveId.getRid((long)t.getLiveId())};
        String msg = MessageFormat.format("Consistency error : {0} owns {1} through {2} , but they are not in the same repository .\n- {0} storage is handled by {3} (rid={5})\n- {1} storage is handled by {4} (rid={6})\n- {0} status : {7} ; live rid = {9}\n- {1} status : {8} ; live rid = {10}\n", args);
        if (!ExmlUtils.areTargetsAlwaysInSameRepository(dep)) {
            Log.trace((String)msg);
            return;
        }
        Log.error((String)msg);
        IllegalArgumentException err = new IllegalArgumentException(VStoreExml.I18N.getMessage("ExmlSaver.reportCompToForeign", args));
        this.errSupport.fireWarning((Throwable)err);
    }

    private final void dumpOBJECT(SmObjectImpl object, Collection<SmObjectImpl> recursionContext, boolean withPid) throws XMLStreamException {
        if (recursionContext.contains(object)) {
            return;
        }
        recursionContext.add(object);
        SmObjectImpl parent = ExmlSaver.getParentExt(object);
        this.out.writeStartElement("OBJECT");
        this.dumpID("ID", (MObject)object);
        if (withPid && parent != null) {
            this.dumpID("PID", (MObject)parent);
        }
        this.dumpATTRIBUTES(object);
        this.dumpDEPENDENCIES(object, recursionContext);
        this.out.writeEndElement();
    }

    private void dumpATT(SmObjectImpl object, SmAttribute att) throws XMLStreamException {
        this.out.writeStartElement("ATT");
        this.out.writeAttribute("name", att.getName());
        Object attVal = object.getAttVal(att);
        if (attVal != null) {
            String stringVal = attVal.toString();
            if (att.getType() == String.class) {
                if (!stringVal.isEmpty()) {
                    this.out.writeCData(ExmlSaver.getCDataForm(stringVal));
                }
            } else {
                this.out.writeCharacters(stringVal);
            }
        }
        this.out.writeEndElement();
    }

    private void dumpATTRIBUTES(SmObjectImpl object) throws XMLStreamException {
        this.out.writeStartElement("ATTRIBUTES");
        for (SmAttribute att : object.getClassOf().getAllAttDef()) {
            this.dumpATT(object, att);
        }
        this.out.writeEndElement();
    }

    private void dumpCOMPS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets, Collection<SmObjectImpl> recursionContext) throws XMLStreamException {
        this.out.writeStartElement("COMP");
        this.out.writeAttribute("relation", dep.getName());
        for (SmObjectImpl t : targets) {
            if (!ExmlUtils.sameRepository(object, t)) {
                this.dumpID("FOREIGNID", (MObject)t);
                continue;
            }
            if (t.getClassOf().isCmsNode()) {
                this.dumpID("COMPID", (MObject)t);
                continue;
            }
            if (recursionContext.contains(t)) {
                this.dumpID("COMPID", (MObject)t);
                continue;
            }
            if (t.getRepositoryObject() != object.getRepositoryObject()) {
                assert (t.getRepositoryObject() instanceof ExmlStorageHandler) : String.format("Broken object: %s has %s as storage handler while saving %s->%s", t, t.getRepositoryObject(), object, dep);
                assert (!ExmlUtils.areTargetsAlwaysInSameRepository(dep)) : String.format("Suspicious identifier instead of whole object for %s->%s : %s", object, dep, t);
                this.dumpREFOBJ((MObject)t);
                continue;
            }
            this.dumpOBJECT(t, recursionContext, false);
        }
        this.out.writeEndElement();
    }

    private void dumpDEPENDENCIES(SmObjectImpl object, Collection<SmObjectImpl> recursionContext) throws XMLStreamException {
        this.out.writeStartElement("DEPENDENCIES");
        List<SmDependency> dependencies = ExmlUtils.getExternalisableDeps(object);
        for (SmDependency dep : dependencies) {
            List content = object.getDepValList(dep);
            if (content.isEmpty()) continue;
            if (ExmlUtils.isDepComponent(dep)) {
                this.dumpCOMPS(object, dep, content, recursionContext);
                continue;
            }
            if (content.isEmpty()) continue;
            this.dumpLINKS(object, dep, content);
        }
        this.out.writeEndElement();
    }

    @Deprecated
    private void dumpFileDEPS(SmObjectImpl object) throws XMLStreamException {
        this.out.writeStartElement("DEPS");
        this.dumpID("ID", (MObject)object);
        ElementDependencies deps = new DependencyAnalyzer().getDependentObjects(object);
        for (MObject it : deps.compNodes) {
            this.dumpID("COMPID", it);
        }
        for (MObject it : deps.refNodes) {
            this.dumpID("EXTID", it);
        }
        for (MObject it : deps.extDeps) {
            this.dumpID("FOREIGNID", it);
        }
        for (MObject it : deps.refDeps) {
            this.dumpREFOBJ(it);
        }
        this.out.writeEndElement();
    }

    private void dumpEXT(SmObjectImpl object) throws XMLStreamException {
        this.out.writeStartElement("EXT");
        this.out.writeAttribute("object", object.getName());
        this.out.writeAttribute("version", Integer.toString(4));
        this.dumpOBJECT(object, new HashSet<SmObjectImpl>(), true);
        this.out.writeEndElement();
    }

    private void dumpID(String xmlkey, MObject object) throws XMLStreamException {
        this.out.writeEmptyElement(xmlkey);
        this.out.writeAttribute("name", Objects.toString(object.getName(), ""));
        this.out.writeAttribute("mc", object.getMClass().getQualifiedName());
        this.out.writeAttribute("uid", object.getUuid().toString());
    }

    private void dumpLINKS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets) throws XMLStreamException {
        this.out.writeStartElement("LINK");
        this.out.writeAttribute("relation", dep.getName());
        for (SmObjectImpl t : targets) {
            if (!ExmlUtils.sameRepository(t, object)) {
                this.dumpID("FOREIGNID", (MObject)t);
                continue;
            }
            if (t.getClassOf().isCmsNode()) {
                this.dumpID("ID", (MObject)t);
                continue;
            }
            this.dumpREFOBJ((MObject)t);
        }
        this.out.writeEndElement();
    }

    private void dumpREFOBJ(MObject object) throws XMLStreamException {
        this.out.writeStartElement("REFOBJ");
        this.dumpID("ID", object);
        this.out.writeEndElement();
    }

    private static String getCDataForm(String aString) {
        return aString.replace("]]>", "]]]><![CDATA[]>");
    }
}

