/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import org.modelio.vbasic.files.CloseOnFail;
import org.modelio.vcore.session.api.blob.IBlobInfo;
import org.modelio.vcore.session.api.repository.BlobServices;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometries;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public abstract class AbstractExmlResourceProvider
implements IExmlResourceProvider {
    private IExmlRepositoryGeometry geometry;

    @Override
    public void createRepository(MMetamodel metamodel) throws IOException {
        this.geometry = ExmlRepositoryGeometries.ofLatest();
        this.doCreateRepository(metamodel);
    }

    @Override
    public final void deleteBlob(String blob) throws IOException {
        String blobPath = this.getGeometry().getBlobPath(blob);
        IExmlResourceProvider.ExmlResource res = this.getRelativePathResource(blobPath);
        res.delete();
    }

    @Override
    public final IExmlRepositoryGeometry getGeometry() {
        if (this.geometry == null) {
            throw new IllegalStateException("Call open() or createRepository() first.");
        }
        return this.geometry;
    }

    @Override
    public IExmlResourceProvider.ExmlResource getLocalResource(ObjId cmsNodeId) throws IOException {
        return this.getRelativePathResource(this.getGeometry().getLocalFileRelativePath(cmsNodeId.toMRef()));
    }

    @Override
    public IExmlResourceProvider.ExmlResource getMetamodelDescriptorResource() throws IOException {
        if (this.geometry == null) {
            this.open();
        }
        return this.getRelativePathResource(this.getGeometry().getMetamodelDescriptorPath());
    }

    @Override
    public final IExmlResourceProvider.ExmlResource getRepositoryVersionResource() throws IOException {
        return this.getRelativePathResource("admin/format_version.dat");
    }

    @Override
    public IExmlResourceProvider.ExmlResource getResource(ObjId id) throws IOException {
        return this.getRelativePathResource(this.getGeometry().getRelativePath(id.toMRef()));
    }

    @Override
    public void open() throws IOException {
        if (this.geometry != null) {
            return;
        }
        if (!this.exists()) {
            throw new FileNotFoundException("The repository at '" + String.valueOf(this.getURI()) + "' does not exist.");
        }
        this.geometry = this.readGeometry();
    }

    @Override
    public final InputStream readBlob(String key) throws IOException {
        String blobPath = this.getGeometry().getBlobPath(key);
        IExmlResourceProvider.ExmlResource res = this.getRelativePathResource(blobPath);
        InputStream is = res.bufferedRead();
        if (is != null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (CloseOnFail c = new CloseOnFail((Closeable)is);){
                BlobServices.readBlobInfo((InputStream)is);
                c.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return is;
    }

    @Override
    public final IBlobInfo readBlobInfo(String key) throws IOException {
        InputStream is;
        block10: {
            IBlobInfo iBlobInfo;
            block11: {
                String blobPath = this.getGeometry().getBlobPath(key);
                IExmlResourceProvider.ExmlResource res = this.getRelativePathResource(blobPath);
                Throwable throwable = null;
                Object var5_6 = null;
                is = res.bufferedRead();
                try {
                    if (is == null) break block10;
                    iBlobInfo = BlobServices.readBlobInfo((InputStream)is);
                    if (is == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                is.close();
            }
            return iBlobInfo;
        }
        if (is != null) {
            is.close();
        }
        return null;
    }

    @Override
    public RepositoryVersions readRepositoryVersion() throws IOException {
        InputStream inStream;
        block13: {
            RepositoryVersions repositoryVersions;
            block14: {
                Throwable throwable = null;
                Object var2_3 = null;
                inStream = this.getRepositoryVersionResource().bufferedRead();
                try {
                    if (inStream == null) break block13;
                    repositoryVersions = RepositoryVersions.fromStream(inStream);
                    if (inStream == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException iOException) {
                        return null;
                    }
                }
                inStream.close();
            }
            return repositoryVersions;
        }
        if (inStream != null) {
            inStream.close();
        }
        return null;
    }

    @Override
    public void updateRepositoryStructure(MMetamodel metamodel) throws IOException {
        this.doCreateRepository(metamodel);
    }

    @Override
    public final OutputStream writeBlob(IBlobInfo info) throws IOException {
        String blobPath = this.getGeometry().getBlobPath(info.getKey());
        IExmlResourceProvider.ExmlResource res = this.getRelativePathResource(blobPath);
        OutputStream os = res.bufferedWrite();
        Throwable throwable = null;
        Object var6_7 = null;
        try (CloseOnFail c = new CloseOnFail((Closeable)os);){
            BlobServices.write((IBlobInfo)info, (OutputStream)os);
            c.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return os;
    }

    protected abstract void doCreateRepository(MMetamodel var1) throws IOException;

    protected IExmlRepositoryGeometry readGeometry() throws IOException {
        RepositoryVersions repositoryVersion = this.readRepositoryVersion();
        int repoFormat = repositoryVersion == null ? 0 : repositoryVersion.getRepositoryFormat();
        return ExmlRepositoryGeometries.ofFormat(repoFormat);
    }
}

