/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometries;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry2;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public class ExmlFileAccess {
    private final File cachedModelPath;
    private final IExmlRepositoryGeometry geometry;
    private final File repositoryRoot;
    private final XMLInputFactory xmlInputFactory;

    public ExmlFileAccess(File repositoryRoot, IExmlRepositoryGeometry geometry) {
        this.repositoryRoot = Objects.requireNonNull(repositoryRoot);
        this.geometry = Objects.requireNonNull(geometry);
        this.cachedModelPath = new File(this.repositoryRoot, this.geometry.getModelPath());
        this.xmlInputFactory = XMLInputFactory.newInstance();
    }

    public ExmlFileAccess copyIn(File newRoot) {
        return new ExmlFileAccess(newRoot, this.geometry);
    }

    public File getBlobFile(String blobKey) {
        return new File(this.repositoryRoot, this.geometry.getBlobPath(blobKey));
    }

    public String getBlobKey(File file) {
        return this.geometry.getBlobKey(this.toRelativePath(file));
    }

    public File getBlobsDirectory() {
        return new File(this.repositoryRoot, "blobs");
    }

    public File getExmlFile(MObject element) {
        return this.getExmlFile(MRef.withoutName((MObject)element));
    }

    public File getExmlFile(MRef ref) {
        return new File(this.repositoryRoot, this.geometry.getRelativePath(ref));
    }

    public IExmlRepositoryGeometry getGeometry() {
        return this.geometry;
    }

    public Collection<File> getInitialDirectories(MMetamodel metamodel) {
        return this.geometry.getInitialDirectories(metamodel).stream().map(p -> new File(this.repositoryRoot, (String)p)).collect(Collectors.toList());
    }

    public File getLocalExmlFile(MRef ref) {
        return new File(this.repositoryRoot, this.geometry.getLocalFileRelativePath(ref));
    }

    public File getMetamodelDescriptorFile() {
        return new File(this.repositoryRoot, "admin/metamodel_descriptor.xml");
    }

    public File getModelDirectory() {
        return this.cachedModelPath;
    }

    public MRef getObRef(File exmlFile) {
        MRef obRef = this.geometry.getObRef(exmlFile.getPath());
        if (obRef.mc.indexOf(46) > 0) {
            try {
                UUID.fromString(obRef.uuid);
                return obRef;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        try {
            return this.readRefFromFile(exmlFile);
        }
        catch (IOException e) {
            if (this.geometry instanceof ExmlRepositoryGeometry2) {
                try {
                    return ExmlRepositoryGeometries.ofLatest().getObRef(exmlFile.getPath());
                }
                catch (RuntimeException e2) {
                    e.addSuppressed(e2);
                }
            }
            Log.warning((String)"Failed reading identifier in '%s': %s", (Object[])new Object[]{exmlFile, FileUtils.getLocalizedMessage((IOException)e)});
            Log.trace((Throwable)e);
            return obRef;
        }
    }

    public boolean isBlobFile(File file) {
        String relativePath = this.toRelativePath(file);
        return relativePath != null && this.geometry.isBlobPath(relativePath);
    }

    public boolean isModelFile(File file) {
        String relativePath = this.toRelativePath(file);
        return relativePath != null && this.geometry.isModelPath(relativePath);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public MRef readRefFromFile(File exmlFile) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(exmlFile);){
                MRef mRef;
                XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(exmlFile.toString(), is);
                try {
                    while (reader.getEventType() != 1 || !reader.getLocalName().equals("ID")) {
                        reader.next();
                    }
                    String mc = reader.getAttributeValue(null, "mc");
                    String name = reader.getAttributeValue(null, "name");
                    String uuid = reader.getAttributeValue(null, "uid");
                    mRef = new MRef(mc, uuid, name);
                }
                catch (Throwable throwable2) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {
                        Log.warning((Throwable)e);
                    }
                    throw throwable2;
                }
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    Log.warning((Throwable)e);
                }
                return mRef;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    private static String getRelativePath(File file, File folder) {
        String folderPath;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(folderPath = folder.getAbsolutePath()) && folderPath.length() < filePath.length()) {
            return filePath.substring(folderPath.length() + 1);
        }
        return null;
    }

    private String toRelativePath(File file) {
        return ExmlFileAccess.getRelativePath(file, this.repositoryRoot);
    }
}

