/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

class ExmlRepositoryCreator {
    private final IExmlRepositoryGeometry geometry;
    private final MMetamodel metamodel;
    private final Path repositoryPath;

    public ExmlRepositoryCreator(Path repositoryPath, IExmlRepositoryGeometry geometry, MMetamodel metamodel) {
        this.repositoryPath = Objects.requireNonNull(repositoryPath);
        this.geometry = Objects.requireNonNull(geometry);
        this.metamodel = Objects.requireNonNull(metamodel);
    }

    public void createRepositoryStructure() throws IOException {
        for (String dir : this.geometry.getInitialDirectories(this.metamodel)) {
            Files.createDirectories(this.repositoryPath.resolve(dir), new FileAttribute[0]);
        }
        Files.createDirectories(this.repositoryPath.resolve(".index"), new FileAttribute[0]);
    }

    public void delete() throws IOException {
        FileUtils.delete((Path)this.repositoryPath);
    }
}

