/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.IOException;
import java.util.Collection;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry1;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry2;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry3;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public class ExmlRepositoryGeometries {
    private static final ExmlRepositoryGeometry1 geometry1 = new ExmlRepositoryGeometry1();
    private static final ExmlRepositoryGeometry2 geometry2 = new ExmlRepositoryGeometry2();
    private static final ExmlRepositoryGeometry3 geometry3 = new ExmlRepositoryGeometry3();

    public static IExmlRepositoryGeometry ofLatest() {
        return geometry3;
    }

    public static IExmlRepositoryGeometry ofLatestStable() {
        return geometry3;
    }

    public static IExmlRepositoryGeometry ofFormat(int repoFormat) throws IOException, UnsupportedOperationException {
        switch (repoFormat) {
            case 0: 
            case 1: {
                return geometry1;
            }
            case 2: {
                return geometry2;
            }
            case 3: {
                return geometry3;
            }
        }
        if (repoFormat == 3) {
            throw new UnsupportedOperationException(String.format("Repository format version '%d' not yet implemented. Last known format is %d .", repoFormat, 3));
        }
        throw new IOException(String.format("Unsupported repository format version '%d'. Last known format is %d .", repoFormat, 3));
    }

    public static IExmlRepositoryGeometry forMigration(int sourceRepoFormat, int targetRepoFormat) throws IOException, UnsupportedOperationException {
        return new HybridExmlRepositoryGeometry(ExmlRepositoryGeometries.ofFormat(sourceRepoFormat), ExmlRepositoryGeometries.ofFormat(targetRepoFormat));
    }

    private static class HybridExmlRepositoryGeometry
    implements IExmlRepositoryGeometry {
        private final IExmlRepositoryGeometry main;
        private final IExmlRepositoryGeometry fallback;

        public HybridExmlRepositoryGeometry(IExmlRepositoryGeometry main, IExmlRepositoryGeometry fallback) {
            this.main = main;
            this.fallback = fallback;
        }

        @Override
        public String getBlobKey(String relativePath) {
            return this.main.getBlobKey(relativePath);
        }

        @Override
        public String getBlobPath(String blobKey) {
            return this.main.getBlobPath(blobKey);
        }

        @Override
        public Collection<String> getInitialDirectories(MMetamodel metamodel) {
            return this.main.getInitialDirectories(metamodel);
        }

        @Override
        public String getLocalFileRelativePath(MRef ref) {
            return this.main.getLocalFileRelativePath(ref);
        }

        @Override
        public String getMetamodelDescriptorPath() {
            return this.main.getMetamodelDescriptorPath();
        }

        @Override
        public int getModelDirectoryLevels() {
            return Math.max(this.main.getModelDirectoryLevels(), this.main.getModelDirectoryLevels());
        }

        @Override
        public String getModelPath() {
            return this.main.getModelPath();
        }

        @Override
        public MRef getObRef(String relativePath) {
            MRef ret = this.main.getObRef(relativePath);
            if (ret != null) {
                return ret;
            }
            return this.fallback.getObRef(relativePath);
        }

        @Override
        public String getRelativePath(MRef ref) {
            return this.main.getRelativePath(ref);
        }

        @Override
        public boolean isBlobPath(String relativePath) {
            return this.main.isBlobPath(relativePath) || this.fallback.isBlobPath(relativePath);
        }

        @Override
        public boolean isModelPath(String relativePath) {
            return this.main.isModelPath(relativePath) || this.fallback.isModelPath(relativePath);
        }
    }
}

