/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.BlobGeometry;
import org.modelio.vstore.exml.resource.GeometryUtils;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public class ExmlRepositoryGeometry1
implements IExmlRepositoryGeometry {
    static final String MODEL_STORAGE_PATH = "model";

    private static String getPath(MRef ref, String extension) {
        return "model/" + ExmlRepositoryGeometry1.getSimpleName(ref.mc) + "/" + ref.uuid + extension;
    }

    @Override
    public MRef getObRef(String exmlFile) {
        String extName = GeometryUtils.getFileName(exmlFile);
        return new MRef(GeometryUtils.getParentFileName(exmlFile), extName.substring(0, extName.lastIndexOf(".exml")));
    }

    @Override
    public boolean isModelPath(String relativePath) {
        if (relativePath != null && relativePath.startsWith(MODEL_STORAGE_PATH) && relativePath.endsWith(".exml") && !relativePath.endsWith(".local.exml")) {
            try {
                this.getObRef(relativePath);
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getModelPath() {
        return MODEL_STORAGE_PATH;
    }

    @Override
    public String getBlobPath(String blobKey) {
        return BlobGeometry.getBlobPath(blobKey);
    }

    @Override
    public String getBlobKey(String file) {
        return BlobGeometry.getBlobKey(file);
    }

    @Override
    public boolean isBlobPath(String relativePath) {
        return relativePath.startsWith(this.getBlobsPath()) && relativePath.endsWith(".blob");
    }

    public String getBlobsPath() {
        return "blobs";
    }

    private static String getSimpleName(String qname) {
        int i = qname.lastIndexOf(46);
        if (i == -1) {
            return qname;
        }
        return qname.substring(i + 1);
    }

    public static String getMetaclassDirectoryName(MClass cls) {
        return cls.getName();
    }

    @Override
    public String getLocalFileRelativePath(MRef ref) {
        return ExmlRepositoryGeometry1.getPath(ref, ".local.exml");
    }

    @Override
    public String getRelativePath(MRef ref) {
        return ExmlRepositoryGeometry1.getPath(ref, ".exml");
    }

    @Override
    public Collection<String> getInitialDirectories(MMetamodel metamodel) {
        ArrayList<String> ret = new ArrayList<String>(600);
        ret.add("admin");
        ret.add(MODEL_STORAGE_PATH);
        for (MClass cmsNodeClass : metamodel.getRegisteredMClasses()) {
            if (!cmsNodeClass.isCmsNode() || cmsNodeClass.isAbstract()) continue;
            ret.add("model/" + ExmlRepositoryGeometry1.getMetaclassDirectoryName(cmsNodeClass));
        }
        ret.add("blobs");
        int i = 0;
        while (i < 256) {
            ret.add(String.format("%s/%02x", "blobs", i));
            ++i;
        }
        return ret;
    }

    @Override
    public String getMetamodelDescriptorPath() {
        return "admin/metamodel_descriptor.xml";
    }

    @Override
    public int getModelDirectoryLevels() {
        return 1;
    }
}

