/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.BlobGeometry;
import org.modelio.vstore.exml.resource.GeometryUtils;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public class ExmlRepositoryGeometry2
implements IExmlRepositoryGeometry {
    static final String MODEL_STORAGE_PATH = "model";

    @Override
    public String getRelativePath(MRef ref) {
        return "model/" + ref.mc + "/" + ref.uuid + ".exml";
    }

    @Override
    public MRef getObRef(String relativePath) {
        String extName = GeometryUtils.getFileName(relativePath);
        return new MRef(GeometryUtils.getParentFileName(relativePath), extName.substring(0, extName.lastIndexOf(".exml")));
    }

    @Override
    public boolean isModelPath(String relativePath) {
        if (relativePath != null && relativePath.startsWith(MODEL_STORAGE_PATH) && relativePath.endsWith(".exml") && !relativePath.endsWith(".local.exml")) {
            try {
                this.getObRef(relativePath);
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getModelPath() {
        return MODEL_STORAGE_PATH;
    }

    @Override
    public String getBlobPath(String blobKey) {
        return BlobGeometry.getBlobPath(blobKey);
    }

    @Override
    public String getBlobKey(String relativePath) {
        return BlobGeometry.getBlobKey(relativePath);
    }

    @Override
    public boolean isBlobPath(String relativePath) {
        return relativePath.startsWith("blobs") && relativePath.endsWith(".blob");
    }

    @Override
    public String getLocalFileRelativePath(MRef ref) {
        return "model/" + ref.mc + "/" + ref.uuid + ".local.exml";
    }

    @Override
    public Collection<String> getInitialDirectories(MMetamodel metamodel) {
        ArrayList<String> ret = new ArrayList<String>(600);
        ret.add("admin");
        ret.add(MODEL_STORAGE_PATH);
        for (MClass cmsNodeClass : metamodel.getRegisteredMClasses()) {
            if (!cmsNodeClass.isCmsNode() || cmsNodeClass.isAbstract()) continue;
            ret.add("model/" + cmsNodeClass.getQualifiedName());
        }
        ret.add("blobs");
        int i = 0;
        while (i < 256) {
            ret.add(String.format("%s/%02x", "blobs", i));
            ++i;
        }
        return ret;
    }

    @Override
    public String getMetamodelDescriptorPath() {
        return "admin/metamodel_descriptor.xml";
    }

    @Override
    public int getModelDirectoryLevels() {
        return 1;
    }
}

