/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.BlobGeometry;
import org.modelio.vstore.exml.resource.GeometryUtils;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public class ExmlRepositoryGeometry3
implements IExmlRepositoryGeometry {
    static final String MODEL_STORAGE_PATH = "model";

    @Override
    public String getRelativePath(MRef ref) {
        return "model/" + ExmlRepositoryGeometry3.defaultHashDir(ref) + ref.uuid + "--" + ref.mc + ".exml";
    }

    @Override
    public String getLocalFileRelativePath(MRef ref) {
        return "model/" + ExmlRepositoryGeometry3.defaultHashDir(ref) + "/" + ref.uuid + "--" + ref.mc + ".local.exml";
    }

    @Override
    public MRef getObRef(String relativePath) {
        String fileName = GeometryUtils.getFileName(relativePath);
        int iSep = fileName.indexOf("--");
        if (iSep == -1) {
            throw new IllegalArgumentException(relativePath);
        }
        String uuid = fileName.substring(0, iSep);
        int lastIndexOf = fileName.lastIndexOf(".exml");
        if (lastIndexOf < iSep) {
            throw new IllegalArgumentException(relativePath);
        }
        String mc = fileName.substring(iSep + 2, lastIndexOf);
        return new MRef(mc, uuid);
    }

    @Override
    public boolean isModelPath(String relativePath) {
        if (relativePath != null && relativePath.startsWith(MODEL_STORAGE_PATH) && relativePath.endsWith(".exml") && !relativePath.endsWith(".local.exml")) {
            try {
                this.getObRef(relativePath);
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getModelPath() {
        return MODEL_STORAGE_PATH;
    }

    @Override
    public String getBlobPath(String blobKey) {
        return BlobGeometry.getBlobPath(blobKey);
    }

    private static String defaultHashDir(MRef ref) {
        StringBuilder out = new StringBuilder(6);
        ExmlRepositoryGeometry3.splitsubString(out, ref.uuid, 9);
        return out.toString();
    }

    private static void splitsubString(StringBuilder out, String uuid, int startAt) {
        int i = startAt;
        int iNext = startAt + 2;
        int len = startAt + 4;
        while (i < len && i < uuid.length()) {
            char c = uuid.charAt(i);
            if (c == '-') {
                ++i;
                ++iNext;
                ++len;
                continue;
            }
            out.append(c);
            if (++i != iNext) continue;
            out.append('/');
            iNext += 2;
        }
    }

    private static void __hashUuid(StringBuilder out, UUID u) {
        switch (u.version()) {
            case 1: {
                ExmlRepositoryGeometry3.splitsubString(out, u.toString(), 8);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ExmlRepositoryGeometry3.splitsubString(out, u.toString(), 0);
                return;
            }
            case 6: 
            case 7: {
                ExmlRepositoryGeometry3.splitsubString(out, u.toString(), 8);
                return;
            }
        }
    }

    @Override
    public String getBlobKey(String relativePath) {
        return BlobGeometry.getBlobKey(relativePath);
    }

    @Override
    public boolean isBlobPath(String relativePath) {
        return relativePath.startsWith("blobs") && relativePath.endsWith(".blob");
    }

    @Override
    public Collection<String> getInitialDirectories(MMetamodel metamodel) {
        ArrayList<String> ret = new ArrayList<String>(600);
        ret.add("admin");
        ret.add(MODEL_STORAGE_PATH);
        ret.add("blobs");
        int i = 0;
        while (i < 256) {
            ret.add(String.format("%s/%02x", "blobs", i));
            ret.add(String.format("%s/%02x", MODEL_STORAGE_PATH, i));
            ++i;
        }
        return ret;
    }

    @Override
    public String getMetamodelDescriptorPath() {
        return "admin/metamodel_descriptor.xml";
    }

    @Override
    public int getModelDirectoryLevels() {
        return 2;
    }
}

