/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vstore.exml.common.index.IndexOutdatedException;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;

public class FsExmlResourceProvider
extends LocalExmlResourceProvider {
    private Path localIndexPath;
    private Path localIndexStampPath;

    public FsExmlResourceProvider(Path distantPath, Path runtimePath, String name) throws IllegalArgumentException, IOException {
        super(distantPath, runtimePath, name);
        if (runtimePath == null) {
            this.localIndexPath = Files.createTempDirectory(distantPath.getFileName().toString(), new FileAttribute[0]);
            this.localIndexStampPath = this.localIndexPath.resolve("index_copy_stamp.dat");
        } else {
            FsExmlResourceProvider.validateLocalPath(runtimePath);
            this.localIndexPath = runtimePath.resolve(".index");
            this.localIndexStampPath = runtimePath.resolve("index_copy_stamp.dat");
        }
    }

    @Override
    public void buildIndexes(IModelioProgress monitor) throws IOException {
        block3: {
            try {
                this.checkLocalIndex();
            }
            catch (IndexOutdatedException e) {
                Log.trace((Throwable)e);
                String msg = "Retrieving '" + this.getName() + "' indexes from '" + String.valueOf(this.repositoryPath) + "' ...";
                Log.trace((String)msg);
                monitor.subTask(msg);
                boolean islocalDir = Files.isDirectory(this.localIndexPath, new LinkOption[0]);
                if (islocalDir) {
                    FileUtils.delete((Path)this.localIndexPath);
                }
                Files.createDirectories(this.localIndexPath, new FileAttribute[0]);
                Path remoteIndexPath = this.repositoryPath.resolve(".index");
                if (!Files.isDirectory(remoteIndexPath, new LinkOption[0])) break block3;
                FileUtils.copyDirectoryTo((Path)remoteIndexPath, (Path)this.localIndexPath);
                Files.write(this.localIndexStampPath, this.getStamp().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
    }

    @Override
    public File getIndexAccessPath() {
        return this.localIndexPath.toFile();
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    private void checkLocalIndex() throws IndexOutdatedException {
        boolean islocalDir = Files.isDirectory(this.localIndexPath, new LinkOption[0]);
        if (!islocalDir) {
            throw new IndexOutdatedException(this.getName() + " indexes not yet copied in '" + String.valueOf(this.localIndexPath) + "'.");
        }
        try {
            String localStamp = this.readLocalStamp();
            if (!localStamp.equals(this.getStamp())) {
                throw new IndexOutdatedException(this.getName() + " local index stamp outdated:\n - local index stamp: " + localStamp + "\n - remote repository stamp: " + this.getStamp());
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new IndexOutdatedException("No '" + String.valueOf(this.localIndexStampPath) + "' stamp file yet.");
        }
        catch (IOException e) {
            throw new IndexOutdatedException("Failed reading '" + String.valueOf(this.localIndexStampPath) + "': " + e.toString(), e);
        }
    }

    private String readLocalStamp() throws IOException, FileSystemException {
        try {
            return FileUtils.readWhole((Path)this.localIndexStampPath, (String)"UTF-8");
        }
        catch (NoSuchFileException e) {
            Path old = this.localIndexStampPath.getParent().resolve("index_stamp.conf");
            try {
                return FileUtils.readWhole((Path)old, (String)"UTF-8");
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }

    private static void validateLocalPath(Path localWorkPath) throws IllegalArgumentException {
        if (localWorkPath.getFileSystem() != FileSystems.getDefault()) {
            throw new IllegalArgumentException(String.valueOf(localWorkPath) + " is not on the local file system.");
        }
        if (!Files.isDirectory(localWorkPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(localWorkPath) + " is not a directory.");
        }
    }
}

