/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.blob.IBlobInfo;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;

public interface IExmlResourceProvider {
    public void buildIndexes(IModelioProgress var1) throws IOException;

    public void close() throws IOException;

    public void commit() throws IOException;

    public void createRepository(MMetamodel var1) throws IOException;

    public void deleteBlob(String var1) throws IOException;

    public boolean exists() throws IOException;

    public Collection<ExmlResource> getAllResources(IModelioProgress var1) throws IOException;

    public Collection<ExmlResource> getAllBlobs(IModelioProgress var1) throws IOException;

    public IExmlRepositoryGeometry getGeometry();

    public File getIndexAccessPath();

    public ExmlResource getLocalResource(ObjId var1) throws IOException;

    public ExmlResource getMetamodelDescriptorResource() throws IOException;

    public String getName();

    public ExmlResource getRelativePathResource(String var1) throws IOException;

    public ExmlResource getRepositoryVersionResource() throws IOException;

    public ExmlResource getResource(ObjId var1) throws IOException;

    public String getStamp() throws IOException;

    public URI getURI();

    public boolean isBrowsable();

    public boolean isWriteable();

    public void open() throws IOException;

    public InputStream readBlob(String var1) throws IOException;

    public IBlobInfo readBlobInfo(String var1) throws IOException;

    public RepositoryVersions readRepositoryVersion() throws IOException;

    public void updateRepositoryStructure(MMetamodel var1) throws IOException;

    public OutputStream writeBlob(IBlobInfo var1) throws IOException;

    public void writeStamp() throws IOException;

    public static interface ExmlResource {
        default public InputStream bufferedRead() throws IOException {
            InputStream is = this.read();
            return is == null ? null : new BufferedInputStream(is);
        }

        default public OutputStream bufferedWrite() throws IOException {
            OutputStream os = this.write();
            return os == null ? null : new BufferedOutputStream(os);
        }

        public void delete() throws IOException;

        public String getPublicLocation();

        public InputStream read() throws IOException;

        public OutputStream write() throws IOException;
    }
}

