/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.resource.AbstractExmlResourceProvider;
import org.modelio.vstore.exml.resource.ExmlRepositoryCreator;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public class LocalExmlResourceProvider
extends AbstractExmlResourceProvider {
    private String name;
    private final Path indexPath;
    private final Path stampPath;
    private final Path versionPath;
    private final Path modelPath;
    private final Path blobPaht;
    protected final Path repositoryPath;

    public LocalExmlResourceProvider(Path repositoryPath, Path runtimePath, String name) {
        this.repositoryPath = repositoryPath;
        this.name = name;
        this.modelPath = repositoryPath.resolve("model");
        this.blobPaht = repositoryPath.resolve("blobs");
        this.stampPath = repositoryPath.resolve("admin").resolve("stamp.dat");
        this.indexPath = runtimePath.resolve(".index");
        this.versionPath = repositoryPath.resolve("admin/format_version.dat");
    }

    @Override
    public void buildIndexes(IModelioProgress monitor) throws IOException {
        Files.createDirectories(this.indexPath, new FileAttribute[0]);
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() throws IOException {
        if (this.isWriteable()) {
            this.writeStamp();
        }
    }

    @Override
    public boolean exists() throws IOException {
        return Files.isDirectory(this.modelPath, new LinkOption[0]);
    }

    @Override
    public Collection<IExmlResourceProvider.ExmlResource> getAllResources(IModelioProgress aMonitor) throws IOException {
        ArrayList toBuild = new ArrayList();
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (String)"Getting all repository content...", (int)5);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> walker = Files.walk(this.modelPath, 10, new FileVisitOption[0]);){
            return walker.filter(p -> p.toString().endsWith(".exml") || p.toString().endsWith(".local.exml")).map(p -> {
                monitor.worked(1);
                monitor.setWorkRemaining(5);
                return new LocalResource((Path)p);
            }).toList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Collection<IExmlResourceProvider.ExmlResource> getAllBlobs(IModelioProgress aMonitor) throws IOException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (String)"Getting all blobs...", (int)5);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> walker = Files.walk(this.blobPaht, 10, new FileVisitOption[0]);){
            return walker.filter(p -> p.toString().endsWith(".blob")).map(p -> {
                monitor.worked(1);
                monitor.setWorkRemaining(5);
                return new LocalResource((Path)p);
            }).toList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public File getIndexAccessPath() {
        return this.indexPath.toFile();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExmlResourceProvider.ExmlResource getRelativePathResource(String relativePath) {
        return new LocalResource(this.repositoryPath.resolve(relativePath));
    }

    @Override
    public String getStamp() {
        try {
            try {
                return FileUtils.readWhole((Path)this.stampPath, (String)"UTF-8");
            }
            catch (NoSuchFileException noSuchFileException) {
                Path old = this.stampPath.getParent().resolve("stamp.conf");
                return FileUtils.readWhole((Path)old, (String)"UTF-8");
            }
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public URI getURI() {
        return this.repositoryPath.toUri();
    }

    @Override
    public boolean isBrowsable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public RepositoryVersions readRepositoryVersion() throws IOException {
        RepositoryVersions v = super.readRepositoryVersion();
        if (v == null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> entries = Files.list(this.modelPath);){
                List<String> cmsNodes = entries.map(p -> p.getFileName().toString()).collect(Collectors.toList());
                return new RepositoryVersions(0, cmsNodes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return v;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "'" + this.name + "' local repository @" + String.valueOf(this.repositoryPath);
    }

    @Override
    public void writeStamp() throws IOException {
        Path stampDir = this.stampPath.getParent();
        if (!stampDir.getFileSystem().isReadOnly()) {
            byte[] bytes = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
            Files.createDirectories(stampDir, new FileAttribute[0]);
            Files.write(this.stampPath, bytes, new OpenOption[0]);
        }
    }

    @Override
    protected void doCreateRepository(MMetamodel metamodel) throws IOException {
        ExmlRepositoryCreator c = new ExmlRepositoryCreator(this.repositoryPath, this.getGeometry(), metamodel);
        c.createRepositoryStructure();
    }

    protected static final class LocalResource
    implements IExmlResourceProvider.ExmlResource {
        private Path p;

        public LocalResource(Path p) {
            this.p = p;
        }

        @Override
        public InputStream read() throws IOException {
            if (!Files.isRegularFile(this.p, new LinkOption[0])) {
                return null;
            }
            return Files.newInputStream(this.p, new OpenOption[0]);
        }

        @Override
        public OutputStream write() throws IOException {
            Files.createDirectories(this.p.getParent(), new FileAttribute[0]);
            return Files.newOutputStream(this.p, new OpenOption[0]);
        }

        @Override
        public void delete() throws IOException {
            Files.deleteIfExists(this.p);
        }

        @Override
        public String getPublicLocation() {
            return this.p.toString();
        }
    }
}

