/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.net.UriConnection;
import org.modelio.vbasic.net.UriConnections;
import org.modelio.vbasic.net.UriUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.common.index.IndexOutdatedException;
import org.modelio.vstore.exml.resource.AbstractExmlResourceProvider;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public class UriExmlResourceProvider
extends AbstractExmlResourceProvider {
    private String name;
    private IAuthData auth;
    private Path localIndexStampPath;
    private URI modelUri;
    private URI stampUrl;
    private URI versionUri;
    private URI url;
    private Path localIndexDir;

    public UriExmlResourceProvider(URI url, Path localDir, IAuthData auth) {
        this.url = UriUtils.asDirectoryUri((URI)url);
        this.auth = auth;
        this.modelUri = this.url.resolve("model/");
        this.stampUrl = this.url.resolve("admin/stamp.dat");
        this.versionUri = this.url.resolve("admin/format_version.dat");
        this.localIndexDir = localDir.resolve(".index");
        this.localIndexStampPath = localDir.resolve("index_copy_stamp.dat");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void buildIndexes(IModelioProgress monitor) throws IOException {
        block13: {
            try {
                this.checkLocalIndex();
                break block13;
            }
            catch (IndexOutdatedException e) {
                Log.trace((Throwable)e);
                msg = "Retrieving '" + this.getName() + "' indexes from '" + String.valueOf(this.url) + "' ...";
                Log.trace((String)msg);
                monitor.subTask(msg);
                isLocalDir = Files.isDirectory(this.localIndexDir, new LinkOption[0]);
                if (isLocalDir) {
                    FileUtils.delete((Path)this.localIndexDir);
                }
                Files.createDirectories(this.localIndexDir, new FileAttribute[0]);
                files = new String[]{"index.dbf.0", "index.dbf.t", "index.dbr.0", "index.dbr.t", "index.idf.0", "index.idf.t", "index.idr.0", "index.idr.t"};
                Files.createDirectories(this.localIndexDir, new FileAttribute[0]);
                var9_6 = files;
                var8_7 = files.length;
                var7_8 = 0;
                ** while (var7_8 < var8_7)
            }
lbl-1000:
            // 1 sources

            {
                f = var9_6[var7_8];
                indexUrl = this.url.resolve(".index/" + f);
                var11_11 = null;
                var12_13 = null;
                try {
                    is = this.openURL(indexUrl).getInputStream();
                    try {
                        target = this.localIndexDir.resolve(f);
                        Files.copy(is, target, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable var12_14) {
                    if (var11_11 == null) {
                        var11_11 = var12_14;
                    } else if (var11_11 != var12_14) {
                        var11_11.addSuppressed(var12_14);
                    }
                    throw var11_11;
                }
                ++var7_8;
                continue;
            }
lbl46:
            // 1 sources

            Files.write(this.localIndexStampPath, this.getStamp().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public boolean exists() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream is = new UriResource(this.url, this.auth).read();){
                boolean bl = is != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return false;
        }
        catch (AccessDeniedException accessDeniedException) {
            return true;
        }
    }

    @Override
    public Collection<IExmlResourceProvider.ExmlResource> getAllResources(IModelioProgress aMonitor) throws IOException {
        throw new AccessDeniedException(this.modelUri.toString(), null, "Impossible to browse a distant repository.");
    }

    @Override
    public Collection<IExmlResourceProvider.ExmlResource> getAllBlobs(IModelioProgress aMonitor) throws IOException {
        throw new AccessDeniedException(this.modelUri.toString(), null, "Impossible to browse a distant repository.");
    }

    @Override
    public File getIndexAccessPath() {
        return this.localIndexDir.toFile();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExmlResourceProvider.ExmlResource getRelativePathResource(String relativePath) {
        return new UriResource(this.url.resolve(relativePath), this.auth);
    }

    @Override
    public String getStamp() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream is = UriConnections.openInputStream((URI)this.stampUrl, (IAuthData)this.auth);){
                return FileUtils.readWhole((InputStream)is, (String)"UTF-8");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return "";
        }
    }

    @Override
    public URI getURI() {
        return this.url;
    }

    @Override
    public boolean isBrowsable() {
        return false;
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void writeStamp() throws IOException {
        throw new AccessDeniedException(this.stampUrl.toString());
    }

    @Override
    protected void doCreateRepository(MMetamodel metamodel) throws IOException {
        throw new AccessDeniedException(this.url.toString());
    }

    private void checkLocalIndex() throws IndexOutdatedException, IOException {
        boolean islocalDir = Files.isDirectory(this.localIndexDir, new LinkOption[0]);
        if (!islocalDir) {
            throw new IndexOutdatedException(this.getName() + " indexes not yet copied in '" + String.valueOf(this.localIndexDir) + "'.");
        }
        String remoteStamp = this.getStamp();
        try {
            String localStamp = this.readLocalStamp();
            if (!localStamp.equals(remoteStamp)) {
                throw new IndexOutdatedException(this.getName() + " local index stamp outdated:\n - local index stamp: " + localStamp + "\n - remote repository stamp: " + remoteStamp);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new IndexOutdatedException("No '" + String.valueOf(this.localIndexStampPath) + "' stamp file yet.");
        }
        catch (IOException e) {
            throw new IndexOutdatedException("Failed reading '" + String.valueOf(this.localIndexStampPath) + "': " + FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    private UriConnection openURL(URI anUrl) throws IOException {
        UriConnection connection = UriConnections.createConnection((URI)anUrl);
        if (this.auth != null) {
            connection.setAuthenticationData(this.auth);
        }
        return connection;
    }

    private String readLocalStamp() throws IOException, FileSystemException {
        return FileUtils.readWhole((Path)this.localIndexStampPath, (String)"UTF-8");
    }

    static class UriResource
    implements IExmlResourceProvider.ExmlResource {
        private URI url;
        private IAuthData auth;

        public UriResource(URI url, IAuthData auth) {
            this.url = url;
            this.auth = auth;
        }

        @Override
        public InputStream read() throws IOException {
            try {
                return this.openURL().getInputStream();
            }
            catch (FileNotFoundException e) {
                Log.warning((String)e.toString());
                return null;
            }
        }

        @Override
        public OutputStream write() throws IOException {
            UriConnection conn = this.openURL();
            conn.setDoOutput(true);
            return conn.getOutputStream();
        }

        @Override
        public void delete() throws IOException {
            throw new AccessDeniedException(this.url.toString());
        }

        @Override
        public String getPublicLocation() {
            return this.url.toString();
        }

        private UriConnection openURL() throws IOException {
            UriConnection connection = UriConnections.createConnection((URI)this.url);
            if (this.auth != null) {
                connection.setAuthenticationData(this.auth);
            }
            return connection;
        }
    }
}

