/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.resource.migration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorReader;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorWriter;
import org.modelio.vcore.smkernel.meta.mof.MofMetamodel;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.plugin.VStoreExml;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry1;
import org.modelio.vstore.exml.resource.ExmlRepositoryGeometry2;

class MigratorFrom1To2 {
    private final int targetFormat;
    private ExmlFileAccess from;
    private ExmlFileAccess to;
    private final Path repositoryPath;
    private final MofMetamodel metamodel;
    private final IMigrationReporter.IMigrationLogger logger;
    private Collection<Path> createdDirectories = new HashSet<Path>();

    public MigratorFrom1To2(Path repositoryPath, MMetamodel metamodel, IMigrationReporter.IMigrationLogger logger) {
        this.repositoryPath = repositoryPath;
        this.metamodel = new MofMetamodel();
        this.logger = logger;
        this.targetFormat = 2;
        this.from = new ExmlFileAccess(repositoryPath.toFile(), new ExmlRepositoryGeometry1());
        this.to = new ExmlFileAccess(repositoryPath.toFile(), new ExmlRepositoryGeometry2());
        this.metamodel.copy(metamodel);
    }

    public void execute(IModelioProgress monitor) throws IOException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)6);
        this.begin((IModelioProgress)mon.newChild(1));
        File metamodelDescriptorFile = this.from.getMetamodelDescriptorFile();
        if (metamodelDescriptorFile.isFile()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream newInputStream = Files.newInputStream(metamodelDescriptorFile.toPath(), new OpenOption[0]);){
                MetamodelDescriptor mmDesc = MetamodelDescriptorReader.readFrom((InputStream)newInputStream, (String)metamodelDescriptorFile.toString());
                this.metamodel.merge(mmDesc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.createMissingDirectories((IModelioProgress)mon.newChild(1));
        this.moveAllResources((IModelioProgress)mon.newChild(1));
        this.deleteObsoleteDirectories((IModelioProgress)mon.newChild(1));
        new FilesRegenerator(this.to, this.metamodel, f -> this.fileModified(f)).run((IModelioProgress)mon.newChild(1));
        this.saveFormatVersion((IModelioProgress)mon.newChild(1));
        this.commit((IModelioProgress)mon.newChild(1));
    }

    protected void commit(IModelioProgress monitor) throws IOException {
    }

    protected void begin(IModelioProgress monitor) throws IOException {
    }

    private void saveFormatVersion(IModelioProgress monitor) throws IOException {
        OutputStream out;
        Path filePath = this.getFormatVersionFilePath();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            out = Files.newOutputStream(filePath, new OpenOption[0]);
            try {
                RepositoryVersions format = new RepositoryVersions(this.targetFormat, (MMetamodel)this.metamodel);
                format.write(out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        filePath = this.getMetamodelDescriptorFilePath();
        throwable = null;
        var4_6 = null;
        try {
            out = Files.newOutputStream(filePath, new OpenOption[0]);
            try {
                MetamodelDescriptor desc = this.metamodel.serialize();
                new MetamodelDescriptorWriter().write(desc, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void createMissingDirectories(IModelioProgress monitor) throws IOException {
        Collection<String> newDirs = this.to.getGeometry().getInitialDirectories((MMetamodel)this.metamodel);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)newDirs.size());
        for (String newDir : newDirs) {
            Path resolvedNewDir = this.repositoryPath.resolve(newDir);
            if (!Files.isDirectory(resolvedNewDir, new LinkOption[0])) {
                this.createNewDirectory(resolvedNewDir);
            }
            mon.worked(1);
        }
    }

    private void deleteObsoleteDirectories(IModelioProgress monitor) throws IOException {
        Collection<File> newDirs = this.to.getInitialDirectories((MMetamodel)this.metamodel);
        Path modelDir = this.repositoryPath.resolve(this.from.getGeometry().getModelPath());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> entries = Files.list(modelDir);){
            Collection oldDirs = entries.collect(Collectors.toList());
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)oldDirs.size());
            int i = 0;
            int count = oldDirs.size();
            for (Path oldDir : oldDirs) {
                monitor.subTask(VStoreExml.I18N.getMessage("MigratorFrom1To2.deletingDirectories.progress", new Object[]{i, count}));
                if (!newDirs.contains(oldDir.toFile()) && !this.createdDirectories.contains(oldDir)) {
                    this.deleteDirectory(oldDir);
                }
                mon.worked(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean deleteDirectory(Path oldDir) throws IOException {
        try {
            return Files.deleteIfExists(oldDir);
        }
        catch (DirectoryNotEmptyException e) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> entries = Files.list(oldDir);){
                    String content = entries.map(d -> "   - " + d.toString()).collect(Collectors.joining("\n", "Directory content:\n", ""));
                    e.addSuppressed(new Throwable(content));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    protected void createNewDirectory(Path newDir) throws IOException {
        Files.createDirectories(newDir, new FileAttribute[0]);
        this.createdDirectories.add(newDir);
    }

    private void moveAllResources(IModelioProgress aMonitor) throws IOException {
        final SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (String)VStoreExml.I18N.getMessage("MigratorFrom1To2.moveAllResources.task", new Object[0]), (int)10);
        MigratorFrom1To2.forEachExmlFile(this.from, new IFileOp(){
            private int count = 0;
            private int movedCount = 0;
            private final ExmlFileAccess fromAccess;
            private final ExmlFileAccess toAccess;
            {
                this.fromAccess = MigratorFrom1To2.this.from;
                this.toAccess = MigratorFrom1To2.this.to;
            }

            @Override
            public void run(Path fromPath) throws IOException {
                File fromFile = fromPath.toFile();
                MRef ref = MigratorFrom1To2.this.readFixedRef(this.fromAccess, fromFile);
                if (ref != null) {
                    Path targetFile;
                    boolean isLocal = fromFile.getPath().endsWith(".local.exml");
                    Path path = targetFile = isLocal ? this.toAccess.getLocalExmlFile(ref).toPath() : this.toAccess.getExmlFile(ref).toPath();
                    if (!fromPath.equals(targetFile)) {
                        MigratorFrom1To2.this.ensureDirectoryExist(targetFile.getParent());
                        MigratorFrom1To2.this.moveFile(fromPath, targetFile);
                        ++this.movedCount;
                    }
                }
                ++this.count;
                monitor.worked(1);
                monitor.setWorkRemaining(10);
                monitor.subTask(VStoreExml.I18N.getMessage("MigratorFrom1To2.moveAllResources.progress", new Object[]{this.count, this.movedCount}));
            }
        });
    }

    protected void moveFile(Path fromPath, Path targetPath) throws IOException {
        Files.move(fromPath, targetPath, new CopyOption[0]);
    }

    protected Path getFormatVersionFilePath() {
        return this.repositoryPath.resolve("admin/format_version.dat");
    }

    protected Path getRepositoryPath() {
        return this.repositoryPath;
    }

    protected final IMigrationReporter.IMigrationLogger getLogger() {
        return this.logger;
    }

    protected final MMetamodel getMetamodel() {
        return this.metamodel;
    }

    private MRef readFixedRef(ExmlFileAccess reader, File fromFile) throws IOException {
        MRef ret = reader.readRefFromFile(fromFile);
        if (ret != null) {
            SmClass mc = this.metamodel.getMClass(ret.mc);
            if (mc == null) {
                this.logger.printf("  warn: %s: Unknown metaclass for '%s'.\n", new Object[]{fromFile, ret});
            } else if (!mc.getQualifiedName().equals(ret.mc)) {
                this.logger.printf("  warn: %s: metaclass fixed to '%s' for '%s'.\n", new Object[]{fromFile, mc.getQualifiedName(), ret});
                ret = new MRef(mc.getQualifiedName(), ret.uuid, ret.name);
            }
        }
        return ret;
    }

    private void ensureDirectoryExist(Path dirPath) throws IOException {
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            this.createNewDirectory(dirPath);
        }
    }

    protected final Path getMetamodelDescriptorFilePath() {
        return this.repositoryPath.resolve(this.to.getGeometry().getMetamodelDescriptorPath());
    }

    protected static final void forEachExmlFile(ExmlFileAccess access, IFileOp op) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> classDs = Files.newDirectoryStream(access.getModelDirectory().toPath(), entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path dir : classDs) {
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir, "*.exml");){
                    for (Path fromPath : dirStream) {
                        op.run(fromPath);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void fileModified(Path modifiedFile) throws IOException {
    }

    protected static class FilesRegenerator {
        private long count;
        private static final Collection<String> tagsToConvert = new HashSet<String>(Arrays.asList("COMPID", "PID", "EXTID", "FOREIGNID", "ID", "PID"));
        private final ExmlFileAccess exmlAccess;
        private final MofMetamodel metamodel;
        private final IFileOp fileModifiedHook;
        private final XMLEventFactory eventFactory;

        public FilesRegenerator(ExmlFileAccess exmlAccess, MofMetamodel metamodel, IFileOp fileModifiedHook) {
            this.exmlAccess = exmlAccess;
            this.metamodel = metamodel;
            this.fileModifiedHook = fileModifiedHook;
            this.eventFactory = XMLEventFactory.newInstance();
        }

        public void run(IModelioProgress amonitor) throws IOException {
            SubProgress monitor = SubProgress.convert((IModelioProgress)amonitor, (int)5);
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            MigratorFrom1To2.forEachExmlFile(this.exmlAccess, exmlFile -> {
                Path tmpFile;
                block28: {
                    tmpFile = Files.createTempFile("", ".exml", new FileAttribute[0]);
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try {
                            InputStream is = Files.newInputStream(exmlFile, new OpenOption[0]);
                            try {
                                block27: {
                                    try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                                        XMLEventReader evReader = inputFactory.createXMLEventReader(exmlFile.toString(), is);
                                        XMLEventWriter evWriter = outputFactory.createXMLEventWriter(os, StandardCharsets.UTF_8.name());
                                        Throwable throwable2 = null;
                                        Object var13_18 = null;
                                        try {
                                            XmlCloser c1 = evReader::close;
                                            try {
                                                try (XmlCloser c2 = evWriter::close;){
                                                    this.rewriteResourceContent(evReader, evWriter);
                                                }
                                                if (c1 == null) break block27;
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable3;
                                                } else if (throwable2 != throwable3) {
                                                    throwable2.addSuppressed(throwable3);
                                                }
                                                if (c1 == null) throw throwable2;
                                                c1.close();
                                                throw throwable2;
                                            }
                                            c1.close();
                                        }
                                        catch (Throwable throwable4) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable4;
                                                throw throwable2;
                                            }
                                            if (throwable2 == throwable4) throw throwable2;
                                            throwable2.addSuppressed(throwable4);
                                            throw throwable2;
                                        }
                                    }
                                }
                                if (is == null) break block28;
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                if (is == null) throw throwable;
                                is.close();
                                throw throwable;
                            }
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                                throw throwable;
                            }
                            if (throwable == throwable6) throw throwable;
                            throwable.addSuppressed(throwable6);
                            throw throwable;
                        }
                    }
                    catch (XMLStreamException e) {
                        throw new IOException(e.getLocalizedMessage(), e);
                    }
                }
                Files.copy(tmpFile, exmlFile, StandardCopyOption.REPLACE_EXISTING);
                this.fileModifiedHook.run(exmlFile);
                Files.delete(tmpFile);
                monitor.worked(1);
                monitor.setWorkRemaining(5);
                monitor.subTask(VStoreExml.I18N.getMessage("FilesRegenerator.progress", new Object[]{++this.count}));
            });
        }

        private void rewriteResourceContent(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent event = (XMLEvent)reader.next();
                if (event.getEventType() == 1 && tagsToConvert.contains(event.asStartElement().getName().getLocalPart())) {
                    event = this.convertIdTag(event.asStartElement());
                }
                writer.add(event);
            }
        }

        private XMLEvent convertIdTag(StartElement event) {
            ArrayList<Attribute> atts = new ArrayList<Attribute>(5);
            Iterator<Attribute> it = event.getAttributes();
            while (it.hasNext()) {
                Attribute att = it.next();
                if (att.getName().getLocalPart().equals("mc")) {
                    String oldMc = att.getValue();
                    SmClass mc = this.metamodel.getMClass(oldMc);
                    if (mc == null) {
                        Location loc = event.getLocation();
                        Log.warning((String)"%s: Unknow '%s' metaclass found at %s:%d:%d", (Object[])new Object[]{this.getClass().getSimpleName(), oldMc, loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber()});
                        atts.add(att);
                        continue;
                    }
                    if (mc.getQualifiedName().equals(oldMc)) {
                        atts.add(att);
                        continue;
                    }
                    atts.add(this.eventFactory.createAttribute(att.getName(), mc.getQualifiedName()));
                    continue;
                }
                atts.add(att);
            }
            return this.eventFactory.createStartElement(event.getName(), atts.iterator(), event.getNamespaces());
        }
    }

    @FunctionalInterface
    public static interface IFileOp {
        public void run(Path var1) throws IOException;
    }

    @FunctionalInterface
    private static interface XmlCloser
    extends AutoCloseable {
        @Override
        public void close() throws XMLStreamException;
    }
}

