/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned;

import java.io.IOException;
import java.io.OutputStream;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

class LazyOutputStream
extends OutputStream {
    private OutputStream os;
    private final IExmlResourceProvider.ExmlResource resource;

    public LazyOutputStream(IExmlResourceProvider.ExmlResource exmlResource) {
        this.resource = exmlResource;
    }

    @Override
    public void write(int b) throws IOException {
        this.getOs().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getOs().write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getOs().write(b);
    }

    @Override
    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        } else {
            this.resource.delete();
        }
    }

    private OutputStream getOs() throws IOException {
        if (this.os == null) {
            this.os = this.resource.bufferedWrite();
        }
        return this.os;
    }
}

