/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.versioned.IVersionStatusInitializer;
import org.modelio.vstore.exml.versioned.VersionedLoadHelper;
import org.modelio.vstore.exml.versioned.load.IVersionedExmlLoader;
import org.modelio.vstore.exml.versioned.load.sax.SaxVersionedExmlLoader;
import org.modelio.vstore.exml.versioned.save.VersionedExmlSaver;
import org.xml.sax.InputSource;

public abstract class VersionedExmlBase
extends AbstractExmlRepository {
    private IVersionedExmlLoader versionedLoader;
    private VersionedLoadHelper loadHelper;

    public VersionedExmlBase(IExmlResourceProvider resProvider) {
        super(resProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void doReloadCmsNode(SmObjectImpl obj, IModelLoader modelLoader) throws DuplicateObjectException, IOException {
        ObjId cmsNodeId = new ObjId(obj);
        IExmlResourceProvider resProvider = this.getResourceProvider();
        IExmlResourceProvider.ExmlResource resource = resProvider.getResource(cmsNodeId);
        IExmlResourceProvider.ExmlResource localRes = resProvider.getLocalResource(cmsNodeId);
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            InputStream is = resource.bufferedRead();
            try {
                try (InputStream lis = localRes.bufferedRead();){
                    if (is == null) {
                        throw new FileNotFoundException(String.valueOf(cmsNodeId) + ": " + resource.getPublicLocation());
                    }
                    InputSource src = new InputSource(is);
                    InputSource lsrc = null;
                    if (lis != null) {
                        lsrc = new InputSource(lis);
                        lsrc.setPublicId(localRes.getPublicLocation());
                    }
                    src.setPublicId(resource.getPublicLocation());
                    this.versionedLoader.load(src, lsrc, modelLoader);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    protected void save(ExmlStorageHandler handler, IModelioProgress progress) throws IOException {
        SmObjectImpl cmsNode = handler.getCmsNode();
        ObjId cmsNodeId = new ObjId(cmsNode);
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream os = this.getResourceProvider().getResource(cmsNodeId).bufferedWrite();){
            VersionedExmlSaver saver = new VersionedExmlSaver(this.getErrorSupport());
            saver.externalize(cmsNode, os, this.getResourceProvider().getLocalResource(cmsNodeId));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected final void initializeLoader() {
        this.loadHelper = new VersionedLoadHelper(this, this.getStatusInitializer(), this.isWriteable());
        this.versionedLoader = new SaxVersionedExmlLoader(this.loadHelper);
    }

    protected abstract IVersionStatusInitializer getStatusInitializer();

    @Override
    protected final ILoadHelper getloadHelper() {
        return this.loadHelper;
    }
}

