/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vcore.smkernel.meta.smannotations.SmDirective;
import org.modelio.vstore.exml.common.utils.ExmlUtils;

public class VersionedNodeDependencies {
    private final Set<MObject> compManagedNodes = new TreeSet<MObject>(MObjectComparator.instance);
    private final Set<MObject> refNodes = new TreeSet<MObject>(MObjectComparator.instance);
    private final Set<MObject> refDeps = new TreeSet<MObject>(MObjectComparator.instance);
    private final MObject parentNode;
    private final Set<MObject> extDeps = new TreeSet<MObject>(MObjectComparator.instance);
    private final Set<MObject> compLocalNodes = new TreeSet<MObject>(MObjectComparator.instance);

    public VersionedNodeDependencies(SmObjectImpl el) {
        this.parentNode = ExmlUtils.getParentCmsNode((MObject)el);
        this.computeDependentObjects(el, new HashSet<MObject>());
        this.compManagedNodes.remove(el);
        this.compLocalNodes.remove(el);
        this.refNodes.remove(el);
        this.refDeps.remove(el);
    }

    public Collection<MObject> getCompLocalNodes() {
        return this.compLocalNodes;
    }

    public Collection<MObject> getCompManagedNodes() {
        return this.compManagedNodes;
    }

    public Collection<MObject> getExtDeps() {
        return this.extDeps;
    }

    public MObject getParentNode() {
        return this.parentNode;
    }

    public Collection<MObject> getUsedObjects() {
        return this.refDeps;
    }

    public Collection<MObject> getUsedNodes() {
        return this.refNodes;
    }

    private void computeDependentObjects(SmObjectImpl object, Collection<MObject> recursionContext) {
        if (recursionContext.contains(object)) {
            return;
        }
        recursionContext.add((MObject)object);
        List dependencies = object.getClassOf().getAllDepDef();
        for (SmDependency dep : dependencies) {
            List depTargets;
            if (ExmlUtils.isDepComponent(dep)) {
                depTargets = object.getDepValList(dep);
                for (SmObjectImpl target : depTargets) {
                    if (!ExmlUtils.sameRepository(object, target)) {
                        this.extDeps.add((MObject)target);
                        continue;
                    }
                    if (target.getMClass().isCmsNode()) {
                        MStatus targetStatus = target.getStatus();
                        if (targetStatus.isCmsManaged() || targetStatus.isCmsToAdd()) {
                            this.compManagedNodes.add((MObject)target);
                            continue;
                        }
                        this.compLocalNodes.add((MObject)target);
                        continue;
                    }
                    this.computeDependentObjects(target, recursionContext);
                }
                continue;
            }
            if (!dep.isPartOf() || dep.hasDirective(SmDirective.SMCD_KEEP_DELETED_ON_READONLY)) continue;
            depTargets = object.getDepValList(dep);
            for (SmObjectImpl target : depTargets) {
                if (!ExmlUtils.sameRepository(object, target)) {
                    this.extDeps.add((MObject)target);
                    continue;
                }
                if (target.getClassOf().isCmsNode()) {
                    this.refNodes.add((MObject)target);
                    continue;
                }
                this.refDeps.add((MObject)target);
                MObject parentCmsNode = ExmlUtils.getParentCmsNode((MObject)target);
                if (parentCmsNode == null) continue;
                this.refNodes.add(parentCmsNode);
            }
        }
        recursionContext.remove(object);
    }

    private static class MObjectComparator
    implements Comparator<MObject> {
        public static final Comparator<MObject> instance = new MObjectComparator();

        @Override
        public int compare(MObject o1, MObject o2) {
            if (o1 == o2) {
                return 0;
            }
            int comp = o1.getName().compareTo(o2.getName());
            if (comp != 0) {
                return comp;
            }
            return o1.getUuid().compareTo(o2.getUuid());
        }
    }
}

