/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned.load.sax.local;

import org.modelio.vbasic.log.Log;
import org.modelio.vstore.exml.versioned.load.sax.local.AbstractState;
import org.modelio.vstore.exml.versioned.load.sax.local.DocumentState;
import org.modelio.vstore.exml.versioned.load.sax.local.LocalDataModel;
import org.modelio.vstore.exml.versioned.load.sax.local.OBJECTState;
import org.modelio.vstore.exml.versioned.load.sax.local.RelationState;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class DocumentContentHandler
extends DefaultHandler {
    private boolean errorEncountered;
    private AbstractState currentState;
    private final RelationState relationState;
    private final DocumentState documentState;
    private Locator locator;
    private final LocalDataModel dataModel;
    private final OBJECTState objectState = new OBJECTState();

    public DocumentContentHandler(LocalDataModel dataModel) {
        this.relationState = new RelationState();
        this.documentState = new DocumentState();
        this.documentState.setStateHandler(this);
        this.relationState.setStateHandler(this);
        this.objectState.setStateHandler(this);
        this.currentState = this.documentState;
        this.errorEncountered = false;
        this.dataModel = dataModel;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.currentState.characters(chars, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentState.endElement(uri, localName, qName);
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        throw exc;
    }

    @Override
    public void fatalError(SAXParseException exc) throws SAXException {
        throw exc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
        this.dataModel.setDocumentLocator(aLocator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.currentState.startElement(uri, localName, qName, atts);
    }

    @Override
    public void warning(SAXParseException exc) {
        Log.warning((Throwable)exc);
    }

    void enterOBJECTState() {
        this.currentState = this.objectState;
    }

    void enterRelationState() {
        this.currentState = this.relationState;
    }

    LocalDataModel getDataModel() {
        return this.dataModel;
    }

    boolean hasEncounteredError() {
        return this.errorEncountered;
    }

    void reset() {
        this.errorEncountered = false;
        this.enterDocumentState();
    }

    void setErrorEncountered() {
        this.errorEncountered = true;
    }

    void throwError(String msg) throws SAXException {
        this.error(new SAXParseException(msg, this.getLocator()));
    }

    void throwFatalError(String msg) throws SAXException {
        this.fatalError(new SAXParseException(msg, this.getLocator()));
    }

    void enterDocumentState() {
        this.currentState = this.documentState;
    }
}

