/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned.load.sax.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.local.loader.sax.IDependencyContentHook;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

final class LocalDataModel
implements ExmlTags {
    private int version;
    ILoadHelper loadHelper;
    IModelLoader modelLoader;
    private ObjectNode currentNode;
    private Collection<ObjectNode> nodes;
    private Locator locator;
    static final List<SmObjectImpl> EMPTY_DEP = Collections.emptyList();
    private static final Collection<ObjectNode> EMPTY_NODES = Collections.emptyList();
    private DepNode currentDepNode = null;

    public LocalDataModel(ILoadHelper loadHelper) {
        this.loadHelper = loadHelper;
        this.modelLoader = null;
        this.nodes = EMPTY_NODES;
    }

    public void reset() {
        this.locator = null;
        this.nodes.clear();
        this.currentNode = null;
        this.currentDepNode = null;
    }

    void addCompId(ObjIdName refid) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        if (refid != null) {
            SmObjectImpl obj = this.loadHelper.getLoadedObject(refid.toObjId());
            if (obj == null) {
                obj = this.loadHelper.createStubObject(this.modelLoader, refid, true);
            }
            this.currentDepNode.add(obj);
        }
    }

    Locator getLocator() {
        return this.locator;
    }

    int getVersion() {
        return this.version;
    }

    void myassert(boolean b) throws AssertionError {
        if (!b) {
            SAXParseException cause = new SAXParseException("assertion failed", this.getLocator());
            throw new AssertionError(cause.getMessage(), cause);
        }
    }

    void myassert(boolean b, String msg) {
        if (!b) {
            SAXParseException cause = new SAXParseException(msg, this.getLocator());
            throw new AssertionError(cause.getMessage(), cause);
        }
    }

    final void beginObject(ObjIdName id) {
        if (this.nodes == EMPTY_NODES) {
            this.nodes = new ArrayList<ObjectNode>(5);
        }
        this.currentNode = new ObjectNode(id.toObjId());
        this.nodes.add(this.currentNode);
    }

    void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
    }

    public void setModelLoader(IModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    void setVersion(int v) {
        this.version = v;
    }

    void beginDependency(String depName) {
        this.currentDepNode = this.currentNode.beginDependency(depName);
    }

    public List<SmObjectImpl> getDependencyContent(SmObjectImpl obj, SmDependency dep) {
        for (ObjectNode objNode : this.nodes) {
            if (!objNode.is(obj.getUuid())) continue;
            for (DepNode depNode : objNode.getDeps()) {
                if (depNode.dep != dep) continue;
                return depNode.getContent();
            }
            return null;
        }
        return null;
    }

    public Collection<? extends IDependencyContentHook.Content> getDependencyContent(SmObjectImpl obj) {
        for (ObjectNode objNode : this.nodes) {
            if (!objNode.is(obj.getUuid())) continue;
            return objNode.getDeps();
        }
        return Collections.emptyList();
    }

    public SmClass getSmClass(String xclassof) {
        return this.loadHelper.getSmClass(xclassof);
    }

    static final class DepNode
    implements IDependencyContentHook.Content {
        List<SmObjectImpl> content;
        SmDependency dep;

        public DepNode(SmDependency adep) {
            this.dep = adep;
            this.content = new ArrayList<SmObjectImpl>();
        }

        void add(SmObjectImpl ref) {
            this.content.add(ref);
        }

        @Override
        public List<SmObjectImpl> getContent() {
            return this.content;
        }

        @Override
        public SmDependency getDep() {
            return this.dep;
        }
    }

    static final class ObjectNode {
        private Collection<DepNode> deps = new ArrayList<DepNode>();
        private ObjId id;

        DepNode beginDependency(String depName) {
            SmDependency dep = this.id.classof.getDependencyDef(depName);
            DepNode newDepNode = new DepNode(dep);
            this.deps.add(newDepNode);
            return newDepNode;
        }

        public String toString() {
            return String.valueOf(this.id) + " ObjectNode, with " + this.deps.size() + " dependencies";
        }

        public ObjectNode(ObjId objid) {
            this.id = objid;
        }

        Collection<DepNode> getDeps() {
            return this.deps;
        }

        public Collection<SmObjectImpl> getDependencyContent(SmDependency dep) {
            for (DepNode d : this.deps) {
                if (d.dep != dep) continue;
                return d.getContent();
            }
            return null;
        }

        boolean is(String uuid) {
            return this.id.id.equals(uuid);
        }
    }
}

