/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned.load.sax.local;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.local.loader.sax.IDependencyContentHook;
import org.modelio.vstore.exml.versioned.load.sax.local.DocumentContentHandler;
import org.modelio.vstore.exml.versioned.load.sax.local.LocalDataModel;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxLocalExmlLoader
implements IDependencyContentHook {
    private boolean loadInProgress;
    private final DocumentContentHandler defaultHandler;
    private XMLReader xmlReader;
    private final LocalDataModel dataModel;

    public SaxLocalExmlLoader(ILoadHelper loadHelper) {
        this.dataModel = new LocalDataModel(loadHelper);
        this.defaultHandler = new DocumentContentHandler(this.dataModel);
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxFactory.newSAXParser();
            this.xmlReader = parser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.xmlReader.setContentHandler(this.defaultHandler);
            this.xmlReader.setErrorHandler(this.defaultHandler);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            throw new Error(e);
        }
    }

    public LocalDataModel load(InputSource is, IModelLoader loader) throws IOException, DuplicateObjectException {
        if (this.loadInProgress) {
            throw new IllegalStateException("Reentrant call not allowed.");
        }
        this.loadInProgress = true;
        this.dataModel.reset();
        this.defaultHandler.reset();
        this.dataModel.setModelLoader(loader);
        try {
            this.xmlReader.parse(is);
            LocalDataModel localDataModel = this.dataModel;
            return localDataModel;
        }
        catch (SAXParseException toCatch) {
            String msg = toCatch.getPublicId() + ":" + toCatch.getLineNumber() + ":" + toCatch.getColumnNumber() + ": " + toCatch.getLocalizedMessage();
            throw new IOException(msg, toCatch);
        }
        catch (SAXException e) {
            String msg = is.getPublicId() + ": " + e.getLocalizedMessage();
            throw new IOException(msg, e);
        }
        catch (IOException e) {
            String msg = is.getPublicId() + ": " + e.getLocalizedMessage();
            throw new IOException(msg, e);
        }
        catch (Error | RuntimeException e) {
            e.addSuppressed(new Throwable("Error occurred while reading '" + is.getPublicId() + "'"));
            throw e;
        }
        finally {
            this.loadInProgress = false;
            this.dataModel.setModelLoader(null);
        }
    }

    public void clear() {
        this.dataModel.reset();
        this.defaultHandler.reset();
    }

    @Override
    public List<SmObjectImpl> getContent(SmObjectImpl obj, SmDependency dep) {
        if (ExmlUtils.isDepComponent(dep)) {
            return this.dataModel.getDependencyContent(obj, dep);
        }
        return null;
    }

    @Override
    public Collection<? extends IDependencyContentHook.Content> getContent(SmObjectImpl obj) {
        return this.dataModel.getDependencyContent(obj);
    }
}

