/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned.save;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.xml.CloseableXMLStreamWriter;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

class LocalSaver
implements AutoCloseable,
ExmlTags {
    private XMLStreamWriter out;
    private SmObjectImpl currentObj;
    private CloseableXMLStreamWriter closeableWriter;
    private SmObjectImpl cmsNode;
    private IExmlResourceProvider.ExmlResource localResource;
    private OutputStream localOs;

    public LocalSaver(IExmlResourceProvider.ExmlResource localResource) {
        this.localResource = localResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws XMLStreamException, IOException {
        if (this.closeableWriter != null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                OutputStream lOs = this.localOs;
                try {
                    try (CloseableXMLStreamWriter c = this.closeableWriter;){
                        if (this.currentObj != null) {
                            this.out.writeEndElement();
                        }
                        this.out.writeEndDocument();
                    }
                    if (lOs == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (lOs == null) throw throwable;
                    lOs.close();
                    throw throwable;
                }
                lOs.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.localResource.delete();
    }

    public void dumpCompId(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets) throws XMLStreamException {
        this.writeProlog();
        if (this.currentObj == null) {
            this.out.writeStartElement("OBJECT");
            this.dumpID("ID", (MObject)object);
            this.currentObj = object;
        } else if (this.currentObj != object) {
            this.out.writeEndElement();
            this.out.writeStartElement("OBJECT");
            this.dumpID("ID", (MObject)object);
            this.currentObj = object;
        }
        this.out.writeStartElement("COMP");
        this.out.writeAttribute("relation", dep.getName());
        for (SmObjectImpl t : targets) {
            this.dumpID("COMPID", (MObject)t);
        }
        this.out.writeEndElement();
    }

    private void dumpID(String xmlkey, MObject object) throws XMLStreamException {
        this.out.writeEmptyElement(xmlkey);
        this.out.writeAttribute("name", object.getName());
        this.out.writeAttribute("mc", object.getMClass().getQualifiedName());
        this.out.writeAttribute("uid", object.getUuid());
    }

    public void begin(SmObjectImpl theCmsNode) {
        this.cmsNode = theCmsNode;
        this.currentObj = null;
    }

    private void writeProlog() throws XMLStreamException {
        if (this.out == null) {
            try {
                this.localOs = this.localResource.bufferedWrite();
                this.closeableWriter = new CloseableXMLStreamWriter(this.localOs, true);
                this.out = this.closeableWriter.getW();
            }
            catch (IOException e) {
                throw new XMLStreamException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
            this.out.writeStartDocument();
            this.out.writeComment("GENERATED FILE, PLEASE DO NOT EDIT!!!");
            this.out.writeStartElement("EXT");
            this.out.writeAttribute("object", this.cmsNode.getName());
            this.out.writeAttribute("version", Integer.toString(4));
        }
    }
}

