/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.versioned.save;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.xml.CloseableXMLStreamWriter;
import org.modelio.vcore.session.api.repository.StorageErrorSupport;
import org.modelio.vcore.session.impl.storage.nullz.NullRepository;
import org.modelio.vcore.smkernel.DeadObjectException;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmLiveId;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.plugin.VStoreExml;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.versioned.save.LocalSaver;

public class VersionedExmlSaver
implements ExmlTags {
    private static final boolean REFOBJ_SANITY_CHECK = false;
    private XMLStreamWriter out;
    private LocalSaver localSaver = null;
    private StorageErrorSupport errSupport;

    private static SmObjectImpl getParentExt(SmObjectImpl object) {
        SmObjectImpl parent = object.getCompositionOwner();
        while (parent != null && !parent.getClassOf().isCmsNode()) {
            parent = parent.getCompositionOwner();
        }
        return parent;
    }

    public VersionedExmlSaver(StorageErrorSupport errSupport) {
        this.errSupport = errSupport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void externalize(SmObjectImpl object, OutputStream os, IExmlResourceProvider.ExmlResource localResource) throws IOException {
        try {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try {
                    CloseableXMLStreamWriter closeableWriter = new CloseableXMLStreamWriter(os, true);
                    try {
                        try (LocalSaver aLocalSaver = new LocalSaver(localResource);){
                            this.localSaver = aLocalSaver;
                            this.out = closeableWriter.getW();
                            this.out.writeStartDocument();
                            this.out.writeComment("GENERATED FILE, PLEASE DO NOT EDIT!!!");
                            this.dumpEXT(object);
                        }
                        if (closeableWriter == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (closeableWriter == null) throw throwable;
                        closeableWriter.close();
                        throw throwable;
                    }
                    closeableWriter.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (FactoryConfigurationError e) {
                throw new IOException(e);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.out = null;
            this.localSaver = null;
        }
    }

    private final void dumpOBJECT(SmObjectImpl object, Collection<SmObjectImpl> recursionContext, boolean withPid) throws XMLStreamException {
        SmObjectImpl parent;
        if (recursionContext.contains(object)) {
            return;
        }
        recursionContext.add(object);
        this.out.writeStartElement("OBJECT");
        this.dumpID("ID", (MObject)object);
        if (withPid && (parent = VersionedExmlSaver.getParentExt(object)) != null) {
            this.dumpID("PID", (MObject)parent);
        }
        this.dumpATTRIBUTES(object);
        this.dumpDEPENDENCIES(object, recursionContext);
        this.out.writeEndElement();
    }

    private void dumpATT(SmObjectImpl object, SmAttribute att) throws XMLStreamException {
        this.out.writeStartElement("ATT");
        this.out.writeAttribute("name", att.getName());
        Object attVal = object.getAttVal(att);
        if (attVal != null) {
            String stringVal = attVal.toString();
            if (att.getType() == String.class) {
                if (!stringVal.isEmpty()) {
                    this.out.writeCData(VersionedExmlSaver.getCDataForm(stringVal));
                }
            } else {
                this.out.writeCharacters(stringVal);
            }
        }
        this.out.writeEndElement();
    }

    private void dumpATTRIBUTES(SmObjectImpl object) throws XMLStreamException {
        this.out.writeStartElement("ATTRIBUTES");
        for (SmAttribute att : object.getClassOf().getAllAttDef()) {
            this.dumpATT(object, att);
        }
        this.out.writeEndElement();
    }

    private void dumpCOMPS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets, Collection<SmObjectImpl> recursionContext) throws XMLStreamException {
        boolean tagWritten = false;
        ArrayList<SmObjectImpl> localTargets = null;
        IRepositoryObject objectHandle = object.getRepositoryObject();
        for (SmObjectImpl target : targets) {
            target.getSmStatusFlags();
            if (!ExmlUtils.sameRepository(object, target)) {
                this.reportCompToForeign(object, dep, object, false);
                tagWritten = this.writeCompTag(tagWritten, dep);
                this.dumpID("FOREIGNID", (MObject)target);
                continue;
            }
            if (target.getClassOf().isCmsNode()) {
                MStatus status = target.getStatus();
                if (status.isCmsManaged() || status.isCmsToAdd()) {
                    tagWritten = this.writeCompTag(tagWritten, dep);
                    this.dumpID("COMPID", (MObject)target);
                    continue;
                }
                if (localTargets == null) {
                    localTargets = new ArrayList<SmObjectImpl>(3);
                }
                localTargets.add(target);
                continue;
            }
            if (recursionContext.contains(target)) {
                tagWritten = this.writeCompTag(tagWritten, dep);
                this.dumpID("COMPID", (MObject)target);
                continue;
            }
            if (VersionedExmlSaver.safeGetRepositoryObject(target) == NullRepository.getInstance()) {
                this.reportRefToOrphan(object, dep, target);
                continue;
            }
            if (VersionedExmlSaver.safeGetRepositoryObject(target) != objectHandle) {
                tagWritten = this.writeCompTag(tagWritten, dep);
                if (VersionedExmlSaver.isComplexCompositionMetaclass(target)) {
                    assert (target.getRepositoryObject() instanceof ExmlStorageHandler) : String.format("Broken object: %s has %s as storage handler while saving %s->%s", target, target.getRepositoryObject(), object, dep);
                    this.dumpREFOBJ(object, dep, target);
                    continue;
                }
                this.reportCompToForeign(object, dep, target, false);
                this.dumpOBJECT(target, recursionContext, false);
                continue;
            }
            tagWritten = this.writeCompTag(tagWritten, dep);
            this.dumpOBJECT(target, recursionContext, false);
        }
        if (tagWritten) {
            this.out.writeEndElement();
        }
        if (localTargets != null) {
            this.localSaver.dumpCompId(object, dep, localTargets);
        }
    }

    private static boolean isComplexCompositionMetaclass(SmObjectImpl obj) {
        String qname;
        switch (qname = obj.getMClass().getQualifiedName()) {
            case "Standard.Link": 
            case "Standard.Connector": 
            case "Standard.ConnectorEnd": 
            case "Standard.Association": 
            case "Standard.LinkEnd": 
            case "Standard.AssociationEnd": 
            case "Standard.Constraint": {
                return true;
            }
        }
        return false;
    }

    private void dumpDEPENDENCIES(SmObjectImpl object, Collection<SmObjectImpl> recursionContext) throws XMLStreamException {
        this.out.writeStartElement("DEPENDENCIES");
        List<SmDependency> dependencies = ExmlUtils.getExternalisableDeps(object);
        for (SmDependency dep : dependencies) {
            List content = object.getDepValList(dep);
            if (content.isEmpty()) continue;
            if (ExmlUtils.isDepComponent(dep)) {
                this.dumpCOMPS(object, dep, content, recursionContext);
                continue;
            }
            this.dumpLINKS(object, dep, content);
        }
        this.out.writeEndElement();
    }

    private void dumpEXT(SmObjectImpl object) throws XMLStreamException {
        this.out.writeStartElement("EXT");
        this.out.writeAttribute("object", object.getName());
        this.out.writeAttribute("version", String.valueOf(4));
        this.localSaver.begin(object);
        this.dumpCmsNodeOBJECT(object);
        this.out.writeEndElement();
    }

    private void dumpID(String xmlkey, MObject object) throws XMLStreamException {
        this.out.writeEmptyElement(xmlkey);
        try {
            this.out.writeAttribute("name", object.getName());
        }
        catch (DeadObjectException deadObjectException) {
            this.out.writeAttribute("name", "*dead*");
        }
        catch (NullPointerException e) {
            if (object == null) {
                throw e;
            }
            this.out.writeAttribute("name", "");
            Log.warning((Throwable)new IllegalArgumentException(String.format("%s name is null", object), e));
        }
        this.out.writeAttribute("mc", object.getMClass().getQualifiedName());
        this.out.writeAttribute("uid", object.getUuid().toString());
    }

    private void dumpLINKS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets) throws XMLStreamException {
        this.out.writeStartElement("LINK");
        this.out.writeAttribute("relation", dep.getName());
        for (SmObjectImpl t : targets) {
            if (!ExmlUtils.sameRepository(t, object)) {
                this.dumpID("FOREIGNID", (MObject)t);
                continue;
            }
            if (t.getClassOf().isCmsNode()) {
                this.dumpID("ID", (MObject)t);
                continue;
            }
            this.dumpREFOBJ(object, dep, t);
        }
        this.out.writeEndElement();
    }

    private final void dumpCmsNodeOBJECT(SmObjectImpl object) throws XMLStreamException {
        this.dumpOBJECT(object, new HashSet<SmObjectImpl>(), true);
    }

    private void dumpREFOBJ(SmObjectImpl from, SmDependency dep, SmObjectImpl object) throws XMLStreamException {
        this.dumpID("ID", (MObject)object);
    }

    private static String getCDataForm(String aString) {
        return aString.replace("]]>", "]]]><![CDATA[]>");
    }

    private void reportRefToOrphan(SmObjectImpl object, SmDependency dep, SmObjectImpl t) {
        String msg = String.valueOf(t) + " is not owned by any CMS node, it will be not saved. It is referenced by " + String.valueOf(object) + "." + String.valueOf(dep) + " relation.";
        IllegalArgumentException err = new IllegalArgumentException(msg);
        this.errSupport.fireWarning((Throwable)err);
    }

    private void reportCompToForeign(SmObjectImpl object, SmDependency dep, SmObjectImpl target, boolean logOnly) {
        IRepositoryObject objectRepositoryObject = VersionedExmlSaver.safeGetRepositoryObject(object);
        IRepositoryObject targetRepositoryObject = VersionedExmlSaver.safeGetRepositoryObject(target);
        try {
            Object[] args = new Object[]{object, target, dep, objectRepositoryObject, targetRepositoryObject, objectRepositoryObject.getRepositoryId(), targetRepositoryObject.getRepositoryId(), object.getStatusLazy(), target.getStatusLazy(), SmLiveId.getRid((long)object.getLiveId()), SmLiveId.getRid((long)target.getLiveId())};
            String msg = MessageFormat.format("Consistency error : {0} owns {1} through {2} , but they are not in the same repository .\n- {0} storage is handled by {3} (rid={5})\n- {1} storage is handled by {4} (rid={6})\n- {0} status : {7} ; live rid = {9}\n- {1} status : {8} ; live rid = {10}\n", args);
            if (!ExmlUtils.areTargetsAlwaysInSameRepository(dep)) {
                Log.trace((String)msg);
                return;
            }
            Log.error((String)msg);
            IllegalArgumentException err = new IllegalArgumentException(VStoreExml.I18N.getMessage("VersionedExmlSaver.reportCompToForeign", args));
            if (logOnly) {
                Log.error((Throwable)err);
            } else {
                this.errSupport.fireWarning((Throwable)err);
            }
        }
        catch (RuntimeException e) {
            Log.error((Throwable)e);
            String msg = MessageFormat.format("Consistency error : {0} owns {1} through {2} , but they are not in the same repository handle.\n(Also an exception was thrown while formatting the message: {3})\n", object, target, dep, e);
            if (logOnly) {
                Log.error((Throwable)new IllegalStateException(msg, e));
            }
            this.errSupport.fireWarning((Throwable)new IllegalStateException(msg, e));
        }
    }

    private boolean writeCompTag(boolean written, SmDependency dep) throws XMLStreamException {
        if (!written) {
            this.out.writeStartElement("COMP");
            this.out.writeAttribute("relation", dep.getName());
        }
        return true;
    }

    private static IRepositoryObject safeGetRepositoryObject(SmObjectImpl target) {
        try {
            return target.getRepositoryObject();
        }
        catch (DeadObjectException deadObjectException) {
            return NullRepository.getInstance();
        }
    }
}

