/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.modelio.platform.ui.UIColor;

public class CoreColorRegistry {
    private static ColorRegistry colors = null;

    static {
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        if (colorRegistry.get("ERROR_COLOR") == null) {
            colorRegistry.put("ERROR_COLOR", UIColor.RED.getRGB());
        }
        if (colorRegistry.get("HYPERLINK_COLOR") == null) {
            colorRegistry.put("HYPERLINK_COLOR", UIColor.SWT_LINK_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("ACTIVE_HYPERLINK_COLOR") == null) {
            colorRegistry.put("ACTIVE_HYPERLINK_COLOR", UIColor.SWT_LINK_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("QUALIFIER_COLOR") == null) {
            colorRegistry.put("QUALIFIER_COLOR", UIColor.SWT_WIDGET_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("DECORATIONS_COLOR") == null) {
            colorRegistry.put("DECORATIONS_COLOR", UIColor.SWT_WIDGET_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("COUNTER_COLOR") == null) {
            colorRegistry.put("COUNTER_COLOR", UIColor.SWT_WIDGET_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("CONTENT_ASSIST_BACKGROUND_COLOR") == null) {
            colorRegistry.put("CONTENT_ASSIST_BACKGROUND_COLOR", UIColor.SWT_INFO_BACKGROUND.getRGB());
        }
        if (colorRegistry.get("CONTENT_ASSIST_FOREGROUND_COLOR") == null) {
            colorRegistry.put("CONTENT_ASSIST_FOREGROUND_COLOR", UIColor.SWT_INFO_FOREGROUND.getRGB());
        }
        if (colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND") == null) {
            colorRegistry.put("org.eclipse.ui.workbench.INFORMATION_BACKGROUND", UIColor.SWT_INFO_BACKGROUND.getRGB());
        }
        if (colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND") == null) {
            colorRegistry.put("org.eclipse.ui.workbench.INFORMATION_FOREGROUND", UIColor.SWT_INFO_FOREGROUND.getRGB());
        }
    }

    public static Color getColor(RGB rgb) {
        String key;
        if (colors == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    colors = new ColorRegistry();
                }
            });
        }
        if (colors.get(key = rgb.toString()) == null) {
            colors.put(key, rgb);
            return colors.get(key);
        }
        return colors.get(key);
    }

    public static Color getDerivedColor(Color color, float factor) {
        RGB rgb = color.getRGB();
        if (factor < 0.0f || factor > 2.0f) {
            throw new IllegalArgumentException(String.valueOf(factor));
        }
        if (factor > 1.0f) {
            rgb.red = (int)((double)rgb.red + (255.0 - (double)rgb.red) * (1.0 - (double)factor));
            rgb.green = (int)((double)rgb.green + (255.0 - (double)rgb.green) * (1.0 - (double)factor));
            rgb.blue = (int)((double)rgb.blue + (255.0 - (double)rgb.blue) * (1.0 - (double)factor));
        } else {
            rgb.red = (int)((float)rgb.red * factor);
            rgb.green = (int)((float)rgb.green * factor);
            rgb.blue = (int)((float)rgb.blue * factor);
        }
        Color resColor = CoreColorRegistry.getColor(rgb);
        return resColor;
    }

    public static Color getIntermediateColor(Color color, RGB target, float factor) {
        if (factor < 0.0f || factor > 1.0f) {
            throw new IllegalArgumentException(String.valueOf(factor));
        }
        RGB rgb = color.getRGB();
        rgb.red = (int)((float)rgb.red + (float)(target.red - rgb.red) * factor);
        rgb.green = (int)((float)rgb.green + (float)(target.green - rgb.green) * factor);
        rgb.blue = (int)((float)rgb.blue + (float)(target.blue - rgb.blue) * factor);
        Color resColor = CoreColorRegistry.getColor(rgb);
        return resColor;
    }
}

