/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontBuilder {
    private FontData[] fontdatas;
    private ResourceManager rm;

    public FontBuilder() {
    }

    public FontBuilder(FontBuilder other) {
        this.fontdatas = FontDescriptor.copy((FontData[])other.fontdatas);
        this.rm = other.rm;
    }

    public FontBuilder addStyle(int styleToAdd) {
        FontData[] fontDataArray = this.fontdatas;
        int n = this.fontdatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(d.getStyle() | styleToAdd);
            ++n2;
        }
        return this;
    }

    public Font build() throws IllegalStateException {
        if (this.rm == null) {
            throw new IllegalStateException("FontBuilder.withAllocator(ResourceManager) must be called first.");
        }
        return (Font)this.rm.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])this.fontdatas));
    }

    public FontDescriptor buildDescriptor() {
        return FontDescriptor.createFrom((FontData[])this.fontdatas);
    }

    public FontBuilder from(Font font) {
        FontData[] afontdatas = font.getFontData();
        return this.from(afontdatas);
    }

    public FontBuilder from(FontData f) {
        Objects.requireNonNull(f);
        return this.from(new FontData[]{f});
    }

    public FontBuilder from(FontData[] initFontDatas) {
        this.fontdatas = Objects.requireNonNull(initFontDatas);
        return this;
    }

    public FontBuilder incHeight(int delta) {
        FontData[] fontDataArray = this.fontdatas;
        int n = this.fontdatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setHeight(d.getHeight() + delta);
            ++n2;
        }
        return this;
    }

    public FontBuilder modify(Consumer<FontData[]> modifier) {
        modifier.accept(this.fontdatas);
        return this;
    }

    public FontBuilder removeStyle(int styleToRemove) {
        FontData[] fontDataArray = this.fontdatas;
        int n = this.fontdatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(d.getStyle() & ~styleToRemove);
            ++n2;
        }
        return this;
    }

    public FontBuilder scale(float scaleFactor) {
        FontData[] fontDataArray = this.fontdatas;
        int n = this.fontdatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setHeight((int)((float)d.getHeight() * scaleFactor));
            ++n2;
        }
        return this;
    }

    public FontBuilder copy() {
        FontBuilder ret = new FontBuilder(this);
        return ret;
    }

    public FontBuilder withAllocator(ResourceManager arm) {
        this.rm = arm;
        return this;
    }
}

