/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui;

import java.util.concurrent.Executor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.modelio.platform.ui.plugin.UI;

public class UIThreadRunner {
    public static void asynExec(Widget context, Runnable runnable) throws IllegalArgumentException {
        if (!UIThreadRunner.checkWidget(context)) {
            return;
        }
        context.getDisplay().asyncExec((Runnable)new SafeRunnable(context, runnable));
    }

    public static void syncExec(Widget context, Runnable runnable) throws IllegalArgumentException {
        if (!UIThreadRunner.checkWidget(context)) {
            return;
        }
        context.getDisplay().syncExec((Runnable)new SafeRunnable(context, runnable));
    }

    private static boolean checkWidget(Widget context) {
        if (context == null) {
            UI.LOG.warning((Throwable)new IllegalArgumentException("Context widget is NULL, runnable ignored."));
            return false;
        }
        if (context.isDisposed()) {
            UI.LOG.debug((Throwable)new IllegalArgumentException("'" + String.valueOf(context) + "' widget is disposed, runnable ignored"));
            return false;
        }
        if (context.getDisplay().isDisposed()) {
            UI.LOG.debug((Throwable)new IllegalArgumentException("'" + String.valueOf(context) + "' widget display is disposed, runnable ignored"));
            return false;
        }
        return true;
    }

    public static void timerExec(Widget context, int milliseconds, Runnable runnable) throws IllegalArgumentException {
        if (!UIThreadRunner.checkWidget(context)) {
            return;
        }
        if (Display.getCurrent() == context.getDisplay()) {
            context.getDisplay().timerExec(milliseconds, (Runnable)new SafeRunnable(context, runnable));
        } else {
            UIThreadRunner.asynExec(context, () -> context.getDisplay().timerExec(milliseconds, (Runnable)new SafeRunnable(context, runnable)));
        }
    }

    public static Executor syncExecutor(Widget context) {
        return runnable -> UIThreadRunner.syncExec(context, runnable);
    }

    public static Executor asyncExecutor(Widget context) {
        return runnable -> UIThreadRunner.syncExec(context, runnable);
    }

    private static class SafeRunnable
    implements Runnable {
        private final Widget widget;
        private final Runnable runnable;

        SafeRunnable(Widget contextWidget, Runnable runnable) {
            this.widget = contextWidget;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            block3: {
                if (this.widget.isDisposed() || this.widget.getDisplay().isDisposed()) {
                    return;
                }
                try {
                    this.runnable.run();
                }
                catch (SWTException e) {
                    if (e.code == 45) break block3;
                    UI.LOG.debug("UIThreadRunner: %s runnable failed.", new Object[]{this.runnable});
                    UI.LOG.error((Throwable)e);
                }
            }
        }
    }
}

