/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.desktop;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class SystemOpener {
    public static void open(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new NoSuchFileException(file.toString());
        }
        String currentOS = System.getProperty("os.name").toLowerCase();
        if (currentOS.contains("nix") || currentOS.contains("nux")) {
            SystemOpener.xdgOpen(file.toString());
        } else if (currentOS.contains("mac")) {
            SystemOpener.macOpen(file.toString());
        } else {
            SystemOpener.desktopOpen(file.toFile());
        }
    }

    public static void browse(URI uri) throws IOException {
        String currentOS = System.getProperty("os.name").toLowerCase();
        if (currentOS.contains("nix") || currentOS.contains("nux")) {
            SystemOpener.xdgOpen(uri.toString());
        } else if (currentOS.contains("mac")) {
            SystemOpener.macOpen(uri.toString());
        } else {
            SystemOpener.desktopBrowse(uri);
        }
    }

    public static void mailto(URI mailUri) throws IOException {
        String currentOS = System.getProperty("os.name").toLowerCase();
        if (currentOS.contains("nix") || currentOS.contains("nux")) {
            SystemOpener.xdgOpen(mailUri.toString());
        } else if (currentOS.contains("mac")) {
            SystemOpener.macOpen(mailUri.toString());
        } else {
            SystemOpener.desktopMailto(mailUri);
        }
    }

    private static void xdgOpen(String toOpen) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        runtime.exec(new String[]{"xdg-open", toOpen});
    }

    private static void macOpen(String toOpen) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        runtime.exec(new String[]{"open", toOpen});
    }

    private static void desktopOpen(File file) throws IOException {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.OPEN)) {
            desktop.open(file);
        }
    }

    private static void desktopBrowse(URI uri) throws IOException {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(uri);
        }
    }

    private static void desktopMailto(URI mailUri) throws IOException {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            desktop.mail(mailUri);
        }
    }
}

