/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.accessibility.AccessibleAttributeAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.modelio.platform.rcp.system.ModelioHelpSystem;
import org.modelio.platform.ui.plugin.UI;

public abstract class ModelioDialog
extends TrayDialog {
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    private static final int MIN_DIALOG_HEIGHT = 250;
    private static final int MIN_DIALOG_WIDTH = 350;
    private String errorMessage;
    private String message = "";
    private int messageLabelHeight;
    private boolean showingError = false;
    private boolean leftImageLargest = false;
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private static final int H_GAP_IMAGE = 5;
    private int xTrim;
    private int yTrim;
    private boolean rightImageLargest = false;
    private Label leftFillerLabel;
    private Image messageImage;
    private Label messageImageLabel;
    private Text messageLabel;
    Color titleAreaColor;
    private RGB titleAreaRGB;
    private Label titleLabel;
    private Image titleRightImage;
    private Label titleRightImageLabel;
    private Composite workArea;
    protected static final Image LEFT_IMAGE = UI.getImageDescriptor("images/headerleft110x50.png").createImage();
    private Label bottomFillerLabel;
    private Image titleLeftImage;
    private Label titleLeftImageLabel;

    public void setBlockOnOpen(boolean shouldBlock) {
        if (!shouldBlock) {
            int style = this.getShellStyle();
            this.setShellStyle(style &= 0xFFFC7FFF);
        }
        super.setBlockOnOpen(shouldBlock);
    }

    protected ModelioDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | ModelioDialog.getDefaultOrientation());
        this.setBlockOnOpen(true);
    }

    protected abstract void addButtonsInButtonBar(Composite var1);

    protected void addDefaultButtons(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.addButtonsInButtonBar(parent);
    }

    protected abstract Control createContentArea(Composite var1);

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)contents);
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.workArea = new Composite(contents, 0);
        GridLayout childLayout = new GridLayout();
        childLayout.marginHeight = 0;
        childLayout.marginWidth = 0;
        childLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)childLayout);
        Control top = this.createTitleArea(contents);
        this.resetWorkAreaAttachments(top);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        this.init();
        Rectangle rect = this.messageLabel.computeTrim(0, 0, 100, 100);
        this.xTrim = rect.width - 100;
        this.yTrim = rect.height - 100;
        this.getShell().addListener(11, event -> this.layoutForNewMessage(true));
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.initHelpButton((Control)this.getShell());
        this.createContentArea(composite);
        return composite;
    }

    protected String getHelpId() {
        return null;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(250), shellSize.y));
    }

    protected abstract void init();

    protected void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        } else {
            String displayedErrorMessage = " " + this.errorMessage;
            this.updateMessage(displayedErrorMessage);
            if (!this.showingError) {
                this.showingError = true;
                this.messageImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR));
                this.setImageLabelVisible(true);
            }
        }
        this.layoutForNewMessage(false);
    }

    protected void setLogoImage(Image newLogoImage) {
        this.titleRightImage = newLogoImage;
        if (this.titleRightImageLabel != null && !this.titleRightImageLabel.isDisposed()) {
            this.titleRightImageLabel.setImage(newLogoImage);
            this.determineTitleImageLargest();
            Object top = this.rightImageLargest ? this.titleRightImageLabel : (this.leftImageLargest ? this.titleLeftImageLabel : this.messageLabel);
            this.resetWorkAreaAttachments((Control)top);
            if (this.dialogArea != null) {
                this.workArea.getParent().layout(true);
            }
        }
    }

    protected void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    protected void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR);
                    break;
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    protected void setTitle(String newTitle) {
        if (this.titleLabel == null) {
            return;
        }
        String title = newTitle;
        if (title == null) {
            title = "";
        }
        this.titleLabel.setText(title);
    }

    protected void setTitleLeftImage(Image newTitleImage) {
        this.titleLeftImage = newTitleImage;
        if (this.titleLeftImageLabel != null) {
            this.titleLeftImageLabel.setImage(newTitleImage);
            this.determineTitleImageLargest();
            Object top = this.rightImageLargest ? this.titleRightImageLabel : (this.leftImageLargest ? this.titleLeftImageLabel : this.messageLabel);
            this.resetWorkAreaAttachments((Control)top);
        }
    }

    protected void setWarningMessage(String newWarningMessage) {
        this.setMessage(newWarningMessage, 2);
    }

    private Control createTitleArea(Composite parent) {
        Color foreground;
        Color background;
        parent.addDisposeListener(e -> {
            if (this.titleAreaColor != null) {
                this.titleAreaColor.dispose();
            }
        });
        Display display = parent.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        parent.setBackground(background);
        this.titleLeftImageLabel = new Label(parent, 0x1000000);
        this.titleLeftImageLabel.setBackground(background);
        if (this.titleLeftImage == null) {
            this.titleLeftImageLabel.setImage(LEFT_IMAGE);
        } else {
            this.titleLeftImageLabel.setImage(this.titleLeftImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.left = new FormAttachment(0, 0);
        this.titleLeftImageLabel.setLayoutData((Object)imageData);
        this.titleRightImageLabel = new Label(parent, 0x1000000);
        this.titleRightImageLabel.setBackground(background);
        if (this.titleRightImage == null) {
            this.titleRightImageLabel.setImage(null);
        } else {
            this.titleRightImageLabel.setImage(this.titleRightImage);
        }
        FormData imageData2 = new FormData();
        imageData2.top = new FormAttachment(0, 0);
        imageData2.right = new FormAttachment(100, 0);
        this.titleRightImageLabel.setLayoutData((Object)imageData2);
        this.titleLabel = new Label(parent, 16384);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, 0);
        titleData.right = new FormAttachment((Control)this.titleRightImageLabel);
        titleData.left = new FormAttachment((Control)this.titleLeftImageLabel, 0);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(parent, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text(parent, 72);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabel.getAccessible().addAccessibleAttributeListener((AccessibleAttributeListener)new AccessibleAttributeAdapter(){

            public void getAttributes(AccessibleAttributeEvent e) {
                e.attributes = new String[]{"container-live", "polite", "live", "polite", "container-live-role", "status"};
            }
        });
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(parent, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.bottomFillerLabel = new Label(parent, 0x1000000);
        this.bottomFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(0, 0);
        this.determineTitleImageLargest();
        if (this.rightImageLargest) {
            return this.titleRightImageLabel;
        }
        if (this.leftImageLargest) {
            return this.titleLeftImageLabel;
        }
        return this.messageLabel;
    }

    private void determineTitleImageLargest() {
        int leftTitleY = this.titleLeftImageLabel.computeSize((int)-1, (int)-1).y;
        int rightTitleY = this.titleRightImageLabel.computeSize((int)-1, (int)-1).y;
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += 0;
        labelY += this.messageLabelHeight;
        if (leftTitleY > (labelY += 0) && leftTitleY >= rightTitleY) {
            this.leftImageLargest = true;
            this.rightImageLargest = false;
        } else if (rightTitleY > labelY && rightTitleY > leftTitleY) {
            this.leftImageLargest = false;
            this.rightImageLargest = true;
        } else {
            this.leftImageLargest = false;
            this.rightImageLargest = false;
        }
    }

    private void initHelpButton(Control control) {
        String helpId = this.getHelpId();
        if (helpId != null && !helpId.isEmpty()) {
            this.setHelpAvailable(true);
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent e) {
                    String hId = ModelioDialog.this.getHelpId();
                    if (hId != null && !hId.isEmpty()) {
                        ModelioHelpSystem.getInstance().displayHelpResource(hId);
                    }
                }
            });
        }
    }

    private void layoutForNewMessage(boolean forceLayout) {
        boolean messageLabelClipped;
        if (this.errorMessage == null && this.messageImage == null) {
            this.setImageLabelVisible(false);
            this.setLayoutsForNormalMessage(0, 0);
        } else {
            this.messageImageLabel.setVisible(true);
            this.bottomFillerLabel.setVisible(true);
            this.leftFillerLabel.setVisible(true);
            FormData data = new FormData();
            data.left = new FormAttachment((Control)this.titleLeftImageLabel, 5);
            data.top = new FormAttachment((Control)this.titleLabel, 0);
            this.messageImageLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0);
            data.left = new FormAttachment((Control)this.titleLeftImageLabel, 0);
            data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0, 131072);
            this.bottomFillerLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
            data.left = new FormAttachment((Control)this.titleLeftImageLabel, 0);
            data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0);
            this.leftFillerLabel.setLayoutData((Object)data);
            FormData messageLabelData = new FormData();
            messageLabelData.top = new FormAttachment((Control)this.titleLabel, 0);
            messageLabelData.right = new FormAttachment((Control)this.titleRightImageLabel);
            messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, 0);
            messageLabelData.height = this.messageLabelHeight;
            if (this.leftImageLargest) {
                messageLabelData.bottom = new FormAttachment((Control)this.titleLeftImageLabel, 0, 1024);
            } else if (this.rightImageLargest) {
                messageLabelData.bottom = new FormAttachment((Control)this.titleRightImageLabel, 0, 1024);
            }
            this.messageLabel.setLayoutData((Object)messageLabelData);
        }
        if (forceLayout) {
            this.getShell().layout();
        } else if (this.dialogArea != null) {
            this.workArea.getParent().layout(true);
        }
        int messageLabelUnclippedHeight = this.messageLabel.computeSize((int)(this.messageLabel.getSize().x - this.xTrim), (int)-1, (boolean)true).y;
        boolean bl = messageLabelClipped = messageLabelUnclippedHeight > this.messageLabel.getSize().y - this.yTrim;
        if (this.messageLabel.getData() instanceof ToolTip) {
            ToolTip toolTip = (ToolTip)this.messageLabel.getData();
            toolTip.hide();
            toolTip.deactivate();
            this.messageLabel.setData(null);
        }
        if (messageLabelClipped) {
            ToolTip tooltip = new ToolTip((Control)this.messageLabel, 2, false){

                protected Composite createToolTipContentArea(Event event, Composite parent) {
                    Composite result = new Composite(parent, 0);
                    result.setBackground(parent.getDisplay().getSystemColor(29));
                    result.setLayout((Layout)new GridLayout());
                    Text text = new Text(result, 64);
                    text.setBackground(parent.getDisplay().getSystemColor(29));
                    text.setForeground(parent.getDisplay().getSystemColor(28));
                    text.setText(ModelioDialog.this.messageLabel.getText());
                    GridData gridData = new GridData();
                    gridData.widthHint = ModelioDialog.this.messageLabel.getSize().x;
                    text.setLayoutData((Object)gridData);
                    Dialog.applyDialogFont((Control)result);
                    return result;
                }

                public Point getLocation(Point tipSize, Event event) {
                    return ModelioDialog.this.messageLabel.getShell().toDisplay(ModelioDialog.this.messageLabel.getLocation());
                }
            };
            this.messageLabel.setData((Object)tooltip);
            tooltip.setPopupDelay(0);
            tooltip.activate();
        }
    }

    private void resetWorkAreaAttachments(Control top) {
        FormData childData = new FormData();
        childData.top = new FormAttachment(top);
        childData.right = new FormAttachment(100, 0);
        childData.left = new FormAttachment(0, 0);
        childData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)childData);
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.bottomFillerLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageImageData = new FormData();
        messageImageData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageImageData.left = new FormAttachment((Control)this.titleLeftImageLabel, 5);
        this.messageImageLabel.setLayoutData((Object)messageImageData);
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleRightImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.leftImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleLeftImageLabel, 0, 1024);
        } else if (this.rightImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleRightImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData fillerData = new FormData();
        fillerData.left = new FormAttachment((Control)this.titleLeftImageLabel, horizontalSpacing);
        fillerData.top = new FormAttachment((Control)this.messageImageLabel, 0);
        fillerData.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.bottomFillerLabel.setLayoutData((Object)fillerData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
        data.left = new FormAttachment((Control)this.titleLeftImageLabel, 0);
        data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
        data.right = new FormAttachment((Control)this.messageImageLabel, 0);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    private void showMessage(String initialMessage, Image newImage) {
        String newMessage;
        String string = newMessage = initialMessage != null ? initialMessage : "";
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        Object shownMessage = newImage == null ? this.message : " " + this.message;
        this.messageImage = newImage;
        if (!this.showingError) {
            this.updateMessage((String)shownMessage);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage(false);
        }
    }

    private void updateMessage(String newMessage) {
        String oldMessage = this.messageLabel.getText();
        this.messageLabel.setText(newMessage);
        this.messageLabel.getAccessible().sendEvent(512, null);
        this.messageLabel.getAccessible().sendEvent(524, (Object)new Object[]{1, 0, oldMessage.length(), oldMessage});
        this.messageLabel.getAccessible().sendEvent(524, (Object)new Object[]{0, 0, newMessage.length(), newMessage});
    }

    public void setTitleAreaColor(RGB color) {
        this.titleAreaRGB = color;
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }

    protected String getMessage() {
        return this.message;
    }

    protected Label getRightTitleImageLabel() {
        return this.titleRightImageLabel;
    }
}

