/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelio.platform.rcp.system.ModelioHelpSystem;
import org.modelio.platform.ui.UIColor;
import org.modelio.platform.ui.UIImages;

public abstract class ModelioDialog2
extends TrayDialog {
    private static final int MIN_DIALOG_HEIGHT = 250;
    private static final int MIN_DIALOG_WIDTH = 350;
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private Composite workArea;
    private ResourceManager resourceManager;

    public void setBlockOnOpen(boolean shouldBlock) {
        if (!shouldBlock) {
            int style = this.getShellStyle();
            this.setShellStyle(style &= 0xFFFC7FFF);
        }
        super.setBlockOnOpen(shouldBlock);
    }

    public void setModal(boolean shouldBlock) {
        if (!shouldBlock) {
            int style = this.getShellStyle();
            this.setShellStyle(style &= 0xFFFC7FFF);
        }
    }

    protected ModelioDialog2(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | ModelioDialog2.getDefaultOrientation());
        this.setBlockOnOpen(true);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected abstract void addButtonsInButtonBar(Composite var1);

    protected void addDefaultButtons(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.addButtonsInButtonBar(parent);
    }

    protected abstract Control createContentArea(Composite var1);

    protected Control createContents(Composite parent) {
        this.getShell().addDisposeListener(e -> this.resourceManager.dispose());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        layout.verticalSpacing = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)composite);
        composite.setBackground(UIColor.WHITE);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        this.setImage(UIImages.MODELIO);
        this.init();
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        buttonBar.setBackground(parent.getBackground());
        Control[] controlArray = buttonBar.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(parent.getBackground());
            ++n2;
        }
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        composite.setBackground(UIColor.WHITE);
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.initHelpButton((Control)this.getShell());
        Control content = this.createContentArea(composite);
        if (content != null && !(content.getLayoutData() instanceof GridData)) {
            throw new IllegalStateException(String.format("%s.createContentArea() returned a %s with no valid GridData layout data", ((Object)((Object)this)).getClass().getName(), content.getClass().getSimpleName()));
        }
        return composite;
    }

    protected String getHelpId() {
        return null;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(250), shellSize.y));
    }

    protected abstract void init();

    protected void setTitle(String title) {
        if (this.getShell() != null) {
            this.getShell().setText(title != null ? title : "");
        }
    }

    protected void setImage(Image image) {
        if (this.getShell() != null) {
            this.getShell().setImage((Image)(image != null ? image : null));
        }
    }

    private void initHelpButton(Control control) {
        String helpId = this.getHelpId();
        if (helpId != null && !helpId.isEmpty()) {
            this.setHelpAvailable(true);
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent e) {
                    String hId = ModelioDialog2.this.getHelpId();
                    if (hId != null && !hId.isEmpty()) {
                        ModelioHelpSystem.getInstance().displayHelpResource(hId);
                    }
                }
            });
        }
    }
}

