/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.modelio.platform.ui.dialog.ModelioDialog;
import org.modelio.platform.ui.panel.IPanelProvider;

public final class ModelioPanelDialog
extends ModelioDialog {
    private final Builder descriptor;
    private final Map<Integer, ButtonAction> buttonActions = new HashMap<Integer, ButtonAction>();

    public static Builder create(IPanelProvider panel) {
        return new Builder(panel);
    }

    public Button getButton(int id) {
        return super.getButton(id);
    }

    private ModelioPanelDialog(Shell parentShell, Builder descriptor) {
        super(parentShell);
        this.descriptor = descriptor;
        this.setBlockOnOpen(this.descriptor.blockOnOpen);
    }

    @Override
    protected void addButtonsInButtonBar(Composite parent) {
        if (this.descriptor.buttons.isEmpty()) {
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        } else {
            for (ButtonData buttonData : this.descriptor.buttons) {
                this.createButton(parent, buttonData.id, buttonData.label, buttonData.isDefault);
                if (buttonData.action == null) continue;
                this.buttonActions.put(buttonData.id, buttonData.action);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String s = this.descriptor.shellTitle == null ? this.descriptor.shellTitle : this.descriptor.headerTitle;
        newShell.setText(s != null ? s : "");
    }

    @Override
    protected Control createContentArea(Composite parent) {
        Control panel = (Control)this.descriptor.panel.createPanel(parent);
        panel.setLayoutData((Object)new GridData(1808));
        panel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.character == '\r' || event.character == '\u1000050' || event.character == '\u001b') {
                    event.doit = false;
                }
            }
        });
        return panel;
    }

    @Override
    protected String getHelpId() {
        return this.descriptor.helpTopic != null ? this.descriptor.helpTopic : this.descriptor.panel.getHelpTopic();
    }

    @Override
    protected void init() {
        this.setTitle(this.descriptor.headerTitle);
        this.setMessage(this.descriptor.message);
        if (this.descriptor.panelInput != null) {
            this.descriptor.panel.setInput(this.descriptor.panelInput);
        }
        if (this.descriptor.onOpenAction != null) {
            this.descriptor.onOpenAction.accept(this);
        }
    }

    protected void buttonPressed(int buttonId) {
        ButtonAction action = this.buttonActions.get(buttonId);
        if (action != null && !((Boolean)action.apply(this)).booleanValue()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Point getInitialSize() {
        Point is = this.descriptor.initialSize;
        return is == null ? super.getInitialSize() : is;
    }

    public IPanelProvider getPanel() {
        return this.descriptor.panel;
    }

    public static class Builder {
        private String shellTitle;
        private String headerTitle;
        private String message;
        private String helpTopic;
        private boolean blockOnOpen = true;
        private Point initialSize;
        private List<ButtonData> buttons = new ArrayList<ButtonData>(3);
        private Consumer<ModelioPanelDialog> onOpenAction;
        private IPanelProvider panel;
        private Object panelInput;

        public Builder(IPanelProvider panel) {
            this.panel = Objects.requireNonNull(panel);
        }

        public ModelioPanelDialog build(Shell parentShell) {
            Objects.requireNonNull(this.panel, "panel not specified");
            if (parentShell == null) {
                Display display = Display.getCurrent();
                if (display == null) {
                    SWT.error((int)22);
                    throw new IllegalStateException();
                }
                return new ModelioPanelDialog(display.getActiveShell(), this);
            }
            return new ModelioPanelDialog(parentShell, this);
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withShellTitle(String shellTitle) {
            this.shellTitle = Objects.requireNonNull(shellTitle);
            return this;
        }

        public Builder withTitle(String title) {
            this.headerTitle = title;
            return this;
        }

        public Builder withButton(int id, String label, ButtonAction action, boolean isDefault) {
            this.buttons.add(new ButtonData(id, label, action, isDefault));
            return this;
        }

        public Builder withOkButton(ButtonAction action, boolean isDefault) {
            return this.withButton(0, IDialogConstants.OK_LABEL, action, isDefault);
        }

        public Builder withCancelButton(ButtonAction action, boolean isDefault) {
            return this.withButton(1, IDialogConstants.CANCEL_LABEL, action, isDefault);
        }

        public Builder withOnOpenAction(Consumer<ModelioPanelDialog> action) {
            this.onOpenAction = action;
            return this;
        }

        public Builder withBlockOnOpen(boolean blockOnOpen) {
            this.blockOnOpen = blockOnOpen;
            return this;
        }

        public Builder withInitialSize(int w, int h) {
            this.initialSize = new Point(w, h);
            return this;
        }

        public Builder withHelpTopic(String helpTopic) {
            this.helpTopic = helpTopic;
            return this;
        }

        public Builder withPanelInput(Object input) {
            this.panelInput = input;
            return this;
        }
    }

    public static interface ButtonAction
    extends Function<ModelioPanelDialog, Boolean> {
    }

    private static class ButtonData {
        public final int id;
        public final String label;
        public final boolean isDefault;
        public ButtonAction action;

        public ButtonData(int id, String label, ButtonAction action, boolean isDefault) {
            this.id = id;
            this.label = label;
            this.action = action;
            this.isDefault = isDefault;
        }
    }
}

