/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.dialog;

import java.util.function.Supplier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.modelio.platform.ui.dialog.PolluxWidgetConfigurator;

public class PolluxFieldBuilder {
    private final Composite parent;
    private Label lastCreatedLabel;
    private Control lastCreatedField;
    private Label lastCreatedCaption;

    public PolluxFieldBuilder(Composite parent) {
        this.parent = parent;
    }

    public <T extends Control> T createSimpleField(String label, Supplier<T> creator, String caption) {
        return this.createField(label, creator, caption, false);
    }

    public <T extends Control> T createMultiField(String label, Supplier<T> creator, String caption) {
        return this.createField(label, creator, caption, true);
    }

    private <T extends Control> T createField(String label, Supplier<T> creator, String caption, boolean multiple) {
        Control field;
        this.lastCreatedCaption = null;
        this.lastCreatedField = null;
        this.lastCreatedLabel = null;
        this.lastCreatedLabel = new Label(this.parent, 0);
        this.lastCreatedLabel.setText(label);
        this.lastCreatedField = field = (Control)creator.get();
        if (caption != null) {
            field.setToolTipText(caption);
            this.lastCreatedCaption = new Label(this.parent, 0);
            this.lastCreatedCaption.setText(caption);
        }
        if (multiple) {
            PolluxWidgetConfigurator.configureMultiField((Control)this.lastCreatedLabel, field, (Control)this.lastCreatedCaption);
        } else {
            PolluxWidgetConfigurator.configureSimpleField((Control)this.lastCreatedLabel, field, (Control)this.lastCreatedCaption);
        }
        return (T)field;
    }

    public Label getLastCreatedCaption() {
        return this.lastCreatedCaption;
    }

    public Control getLastCreatedField() {
        return this.lastCreatedField;
    }

    public Label getLastCreatedLabel() {
        return this.lastCreatedLabel;
    }
}

