/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.dialog;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.modelio.platform.ui.UIColor;
import org.modelio.platform.ui.UIFont;

public class PolluxWidgetConfigurator {
    public static final int VERTICAL_SPACING = 1;
    public static final int FIELD_VERTICAL_SPACING = 5;

    public static void configureContainer(Composite composite) {
        if (composite == null) {
            throw new IllegalArgumentException("'control' cannot be null.");
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(UIColor.WHITE);
    }

    public static void configureSimpleField(Control label, Control control, Control caption) {
        if (control == null) {
            throw new IllegalArgumentException("'control' cannot be null.");
        }
        Composite container = control.getParent();
        if (label != null && label.getParent() != container || caption != null && caption.getParent() != container) {
            throw new IllegalArgumentException("All controls must belong to the same Composite parent.");
        }
        if (!(container.getLayout() instanceof GridLayout)) {
            throw new IllegalArgumentException("The controls parent Composite layout must be of type GridLayout.");
        }
        GridLayout gridLayout = (GridLayout)container.getLayout();
        if (gridLayout.numColumns != 1) {
            throw new IllegalArgumentException("The controls Composite parent layout must be of type one-column GridLayout.");
        }
        if (label != null) {
            GridData labelGd = new GridData(4, 1024, true, false);
            labelGd.verticalIndent = 5;
            label.setLayoutData((Object)labelGd);
            PolluxWidgetConfigurator.configureStyleForFieldLabel(label);
        }
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        PolluxWidgetConfigurator.configureStyleForFieldControl(control);
        if (caption != null) {
            caption.setLayoutData((Object)new GridData(4, 128, true, false));
            PolluxWidgetConfigurator.configureStyleForFieldCaption(caption);
        }
    }

    public static void configureStyleForFieldLabel(Control label) {
        Composite container = label.getParent();
        label.setFont(UIFont.NORMALB);
        label.setForeground(UIColor.GRAY);
        label.setBackground(container.getBackground());
    }

    public static void configureStyleForFieldControl(Control control) {
        Composite container = control.getParent();
        control.setFont(UIFont.NORMAL);
        control.setForeground(UIColor.TEXT_WRITABLE_FG);
        control.setBackground(container.getBackground());
    }

    public static void configureStyleForFieldCaption(Control caption) {
        Composite container = caption.getParent();
        caption.setFont(UIFont.SMALLI);
        caption.setForeground(UIColor.SWT_LIST_SELECTION);
        caption.setBackground(container.getBackground());
    }

    public static void configureSimpleCompositeField(Composite comp, Control label, Control control, Control caption) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setBackground(UIColor.WHITE);
        PolluxWidgetConfigurator.configureSimpleField(label, control, caption);
    }

    public static void configureMultiField(Control label, Control control, Control caption) {
        PolluxWidgetConfigurator.configureSimpleField(label, control, caption);
        ((GridData)control.getLayoutData()).grabExcessVerticalSpace = true;
    }

    public static void configureMultiCompositeField(Composite comp, Control label, Control control, Control caption) {
        PolluxWidgetConfigurator.configureSimpleCompositeField(comp, label, control, caption);
        ((GridData)control.getLayoutData()).grabExcessVerticalSpace = true;
    }

    public static void configureHeaderField(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("'control' cannot be null.");
        }
        Composite container = control.getParent();
        GridLayout gridLayout = (GridLayout)container.getLayout();
        if (gridLayout.numColumns != 1) {
            throw new IllegalArgumentException("The controls Composite parent layout must be of type one-column GridLayout.");
        }
        control.setFont(UIFont.XLARGEB);
        control.setForeground(UIColor.SWT_LIST_SELECTION);
        control.setBackground(container.getBackground());
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 2;
        control.setLayoutData((Object)gd);
    }

    public static void configureHeaderStyle(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("'control' cannot be null.");
        }
        Composite container = control.getParent();
        control.setFont(UIFont.XLARGEB);
        control.setForeground(UIColor.SWT_LIST_SELECTION);
        control.setBackground(container.getBackground());
    }

    public static void configureSimpleCompositeField(Composite comp, Control label, Control mainControl, Control caption, Control editControl) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setBackground(UIColor.WHITE);
        if (label != null) {
            GridData labelGd = new GridData(4, 1024, true, false, 2, 1);
            labelGd.verticalIndent = gridLayout.verticalSpacing * 2;
            label.setLayoutData((Object)labelGd);
            label.setFont(UIFont.NORMALB);
            label.setForeground(UIColor.SWT_LIST_SELECTION);
            label.setBackground(comp.getBackground());
        }
        if (editControl != null) {
            mainControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            mainControl.setFont(UIFont.NORMAL);
            mainControl.setForeground(UIColor.TEXT_WRITABLE_FG);
            mainControl.setBackground(comp.getBackground());
            editControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            editControl.setFont(UIFont.NORMAL);
            editControl.setForeground(UIColor.TEXT_WRITABLE_FG);
            editControl.setBackground(comp.getBackground());
        } else {
            mainControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            mainControl.setFont(UIFont.NORMAL);
            mainControl.setForeground(UIColor.TEXT_WRITABLE_FG);
            mainControl.setBackground(comp.getBackground());
        }
        if (caption != null) {
            caption.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            caption.setFont(UIFont.SMALLI);
            caption.setForeground(UIColor.SWT_LIST_SELECTION);
            caption.setBackground(comp.getBackground());
        }
    }
}

