/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.htmleditor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.modelio.platform.ui.UIThreadRunner;
import org.modelio.platform.ui.htmleditor.commands.Command;
import org.modelio.platform.ui.htmleditor.commands.GetHtmlCommand;
import org.modelio.platform.ui.htmleditor.commands.SetHtmlCommand;
import org.modelio.platform.ui.htmleditor.events.NodeSelectionEvent;
import org.modelio.platform.ui.htmleditor.listener.NodeSelectionChangeListener;
import org.modelio.platform.ui.htmleditor.util.ColorConverter;
import org.modelio.platform.ui.plugin.UI;
import org.modelio.platform.ui.swt.BrowserConfigurator;
import org.modelio.vbasic.files.FileUtils;
import org.osgi.framework.Bundle;

public class HtmlComposer {
    private volatile boolean initialized;
    private String lastHtmlContent;
    private boolean debugMode;
    private final List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private final List<ModifyListener> modifyListenerList = new ArrayList<ModifyListener>();
    private final List<Runnable> pendingActions = Collections.synchronizedList(new ArrayList());
    private final Browser browser;
    private final List<NodeSelectionChangeListener> selectionListenerList = new ArrayList<NodeSelectionChangeListener>();
    private final Map<String, Command> trackedCommands = new HashMap<String, Command>();

    private boolean isAsyncRegistration() {
        switch (this.browser.getBrowserType()) {
            case "edge": {
                return true;
            }
            case "ie": {
                return false;
            }
            case "webkit": {
                return true;
            }
        }
        return true;
    }

    private void debugLog(String format, Object ... args) {
        if (this.debugMode) {
            UI.LOG.debug(String.format(format, args));
        }
    }

    private void debugLog(String format) {
        if (this.debugMode) {
            UI.LOG.debug(format);
        }
    }

    public HtmlComposer(Composite parent, int style) {
        URL baseUrl;
        this.debugMode = System.getProperty("modelio.editor.html.debug", "false").equalsIgnoreCase("true");
        this.browser = System.getProperty("modelio.editor.html.variant", "0").equals("1") ? BrowserConfigurator.newBrowser(parent, style) : BrowserConfigurator.oldBrowser(parent, style);
        this.browser.setMenu(new Menu((Control)this.browser));
        final boolean needAsyncRegistration = this.isAsyncRegistration();
        if (!needAsyncRegistration) {
            this.registerBrowserFunctions();
        }
        try {
            baseUrl = FileLocator.resolve((URL)FileLocator.find((Bundle)UI.getContext().getBundle(), (IPath)new Path("rte/js/base.html"), Map.of()));
        }
        catch (IOException e) {
            throw new LinkageError(FileUtils.getLocalizedMessage((IOException)e), e);
        }
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                UIThreadRunner.asynExec((Widget)HtmlComposer.this.browser, () -> HtmlComposer.this.onPageLoaded(needAsyncRegistration));
                HtmlComposer.this.browser.removeProgressListener((ProgressListener)this);
            }
        });
        this.browser.setUrl(baseUrl.toString());
    }

    private void onPageLoaded(boolean isAsyncRegister) {
        if (this.debugMode) {
            this.debugLog("HtmlComposer: Injecting Eruda console for debug...");
            this.injectErudaConsole();
        }
        if (isAsyncRegister) {
            this.registerBrowserFunctions();
        }
    }

    private void injectErudaConsole() {
        String erudaScript = "var script = document.createElement('script');\nscript.src = 'eruda.js';\ndocument.body.appendChild(script);\nscript.onload = function () {\n    eruda.init();\n    eruda.show('console');\n};\n";
        this.executeNow(erudaScript);
    }

    public void addControlListener(ControlListener listener) {
        this.browser.addControlListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.browser.addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        if (this.initialized) {
            this.focusListeners.add(listener);
        } else {
            this.pendingActions.add(() -> this.addFocusListener(listener));
        }
    }

    public boolean hasFocus() {
        return this.browser.isFocusControl();
    }

    public void addHelpListener(HelpListener listener) {
        this.browser.addHelpListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.initialized) {
            this.modifyListenerList.add(listener);
        } else {
            this.pendingActions.add(() -> this.addModifyListener(listener));
        }
    }

    public void addNodeSelectionChangeListener(NodeSelectionChangeListener listener) {
        this.selectionListenerList.add(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.browser.addPaintListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.browser.addTraverseListener(listener);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.browser.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.browser.computeSize(wHint, hHint, changed);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.browser.computeTrim(x, y, width, height);
    }

    public void dispose() {
        if (this.focusListeners != null) {
            this.focusListeners.clear();
        }
        this.browser.dispose();
    }

    public Object evaluate(String script) throws SWTException {
        if (this.browser.isDisposed()) {
            return null;
        }
        try {
            return this.browser.evaluate(script);
        }
        catch (Exception e) {
            UI.LOG.debug((Throwable)e);
            return null;
        }
    }

    private boolean executeNow(String script) {
        try {
            this.debugLog("Executing script: " + script);
            this.browser.execute(script);
            return true;
        }
        catch (RuntimeException e) {
            UI.LOG.warning((Throwable)e);
            return false;
        }
    }

    public void execute(Command command) {
        if (this.initialized) {
            this.executeNow(command.getScript());
        } else {
            this.pendingActions.add(() -> this.execute(command));
        }
    }

    public Object executeWithReturn(Command command) {
        if (this.initialized) {
            return this.evaluate(command.getScript());
        }
        return null;
    }

    public boolean forceFocus() {
        return this.browser.forceFocus();
    }

    public Accessible getAccessible() {
        return this.browser.getAccessible();
    }

    public Color getBackground() {
        return this.browser.getBackground();
    }

    public Image getBackgroundImage() {
        return this.browser.getBackgroundImage();
    }

    public int getBackgroundMode() {
        return this.browser.getBackgroundMode();
    }

    public int getBorderWidth() {
        return this.browser.getBorderWidth();
    }

    public Rectangle getBounds() {
        return this.browser.getBounds();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Control[] getChildren() {
        return this.browser.getChildren();
    }

    public Rectangle getClientArea() {
        return this.browser.getClientArea();
    }

    public Cursor getCursor() {
        return this.browser.getCursor();
    }

    public Object getData() {
        return this.browser.getData();
    }

    public Object getData(String key) {
        return this.browser.getData(key);
    }

    public Display getDisplay() {
        return this.browser.getDisplay();
    }

    public boolean getEnabled() {
        return this.browser.getEnabled();
    }

    public Font getFont() {
        return this.browser.getFont();
    }

    public Color getForeground() {
        return this.browser.getForeground();
    }

    public ScrollBar getHorizontalBar() {
        return this.browser.getHorizontalBar();
    }

    public String getHtml() {
        GetHtmlCommand getHtmlCommand = new GetHtmlCommand();
        Object executeWithReturn = this.executeWithReturn(getHtmlCommand);
        if (executeWithReturn != null) {
            String ret;
            this.lastHtmlContent = ret = String.valueOf(executeWithReturn).replace("</p>\n\n<p", "</p><p").replace("</p>\n\n<table", "</p><table").replace("</table>\n\n<p", "</table><p");
            return ret;
        }
        return null;
    }

    public Layout getLayout() {
        return this.browser.getLayout();
    }

    public Object getLayoutData() {
        return this.browser.getLayoutData();
    }

    public boolean getLayoutDeferred() {
        return this.browser.getLayoutDeferred();
    }

    public Listener[] getListeners(int eventType) {
        return this.browser.getListeners(eventType);
    }

    public Point getLocation() {
        return this.browser.getLocation();
    }

    public Menu getMenu() {
        return this.browser.getMenu();
    }

    public Monitor getMonitor() {
        return this.browser.getMonitor();
    }

    public Composite getParent() {
        return this.browser.getParent();
    }

    public Region getRegion() {
        return this.browser.getRegion();
    }

    public Shell getShell() {
        return this.browser.getShell();
    }

    public Point getSize() {
        return this.browser.getSize();
    }

    public int getStyle() {
        return this.browser.getStyle();
    }

    public Control[] getTabList() {
        return this.browser.getTabList();
    }

    public ScrollBar getVerticalBar() {
        return this.browser.getVerticalBar();
    }

    public boolean getVisible() {
        return this.browser.getVisible();
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    public boolean isEnabled() {
        return this.browser.isEnabled();
    }

    public boolean isFocusControl() {
        return this.browser.isFocusControl();
    }

    public boolean isLayoutDeferred() {
        return this.browser.isLayoutDeferred();
    }

    public boolean isListening(int eventType) {
        return this.browser.isListening(eventType);
    }

    public boolean isReparentable() {
        return this.browser.isReparentable();
    }

    public boolean isVisible() {
        return this.browser.isVisible();
    }

    public void layout() {
        this.browser.layout();
    }

    public void layout(boolean changed) {
        this.browser.layout(changed);
    }

    public void layout(boolean changed, boolean all) {
        this.browser.layout(changed, all);
    }

    public void layout(Control[] changed) {
        this.browser.layout(changed);
    }

    public void moveAbove(Control control) {
        this.browser.moveAbove(control);
    }

    public void moveBelow(Control control) {
        this.browser.moveBelow(control);
    }

    public void notifyListeners(int eventType, Event event) {
        this.browser.notifyListeners(eventType, event);
    }

    public void pack() {
        this.browser.pack();
    }

    public void pack(boolean changed) {
        this.browser.pack(changed);
    }

    public boolean print(GC gc) {
        return this.browser.print(gc);
    }

    public void redraw() {
        this.browser.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.browser.redraw(x, y, width, height, all);
    }

    public void refresh() {
        this.browser.refresh();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.browser.removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListeners.remove(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.browser.removeHelpListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListenerList.remove(listener);
        if (!this.initialized) {
            this.pendingActions.add(() -> this.removeModifyListener(listener));
        }
    }

    public void removeNodeSelectionChangeListener(NodeSelectionChangeListener listener) {
        this.selectionListenerList.remove(listener);
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.browser.removeOpenWindowListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.browser.removePaintListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.browser.removeTraverseListener(listener);
    }

    public void setBackground(final Color color) {
        this.browser.setBackground(color);
        this.execute(new Command("set_background_internal"){

            @Override
            public String getScript() {
                String hexValue = color != null ? "#" + ColorConverter.convertRgbToHex(color.getRGB()) : "";
                return "document.getElementById('cke_editor1_arialbl').nextSibling.style.backgroundColor = '" + hexValue + "';";
            }
        });
    }

    public void setBackgroundImage(Image image) {
        this.browser.setBackgroundImage(image);
    }

    public void setBackgroundMode(int mode) {
        this.browser.setBackgroundMode(mode);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.browser.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.browser.setBounds(rect);
    }

    public void setCapture(boolean capture) {
        this.browser.setCapture(capture);
    }

    public void setCursor(Cursor cursor) {
        this.browser.setCursor(cursor);
    }

    public void setData(Object data) {
        this.browser.setData(data);
    }

    public void setData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public void setEditable(boolean onOff) {
        if (this.initialized) {
            if (onOff) {
                this.executeNow("CKEDITOR.instances.editor1.setReadOnly(false)");
            } else {
                this.executeNow("CKEDITOR.instances.editor1.setReadOnly(true)");
            }
        } else {
            this.pendingActions.add(() -> this.setEditable(onOff));
        }
    }

    public void setEnabled(boolean enabled) {
        this.browser.setEnabled(enabled);
    }

    public boolean setFocus() {
        if (this.isInitialized()) {
            this.browser.execute("integration.editor.focus();");
        } else {
            this.pendingActions.add(() -> this.browser.execute("integration.editor.focus();"));
        }
        boolean setFocus = this.browser.setFocus();
        return setFocus;
    }

    public void setFont(Font font) {
        this.browser.setFont(font);
    }

    public void setForeground(Color color) {
        this.browser.setForeground(color);
    }

    public void setHtml(String html) {
        if (Objects.equals(html, this.lastHtmlContent)) {
            return;
        }
        SetHtmlCommand setHtmlCommand = new SetHtmlCommand(html);
        this.execute(setHtmlCommand);
        this.lastHtmlContent = html;
    }

    public void setLayout(Layout layout) {
        this.browser.setLayout(layout);
    }

    public void setLayoutData(Object layoutData) {
        this.browser.setLayoutData(layoutData);
    }

    public void setLayoutDeferred(boolean defer) {
        this.browser.setLayoutDeferred(defer);
    }

    public void setLocation(int x, int y) {
        this.browser.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.browser.setLocation(location);
    }

    public void setMenu(Menu menu) {
        this.browser.setMenu(menu);
    }

    public boolean setParent(Composite parent) {
        return this.browser.setParent(parent);
    }

    public void setRedraw(boolean redraw) {
        this.browser.setRedraw(redraw);
    }

    public void setRegion(Region region) {
        this.browser.setRegion(region);
    }

    public void setSize(int width, int height) {
        this.browser.setSize(width, height);
    }

    public void setSize(Point size) {
        this.browser.setSize(size);
    }

    public void setTabList(Control[] tabList) {
        this.browser.setTabList(tabList);
    }

    public void setVisible(boolean visible) {
        this.browser.setVisible(visible);
    }

    public Point toControl(int x, int y) {
        return this.browser.toControl(x, y);
    }

    public Point toControl(Point point) {
        return this.browser.toControl(point);
    }

    public Point toDisplay(int x, int y) {
        return this.browser.toDisplay(x, y);
    }

    public Point toDisplay(Point point) {
        return this.browser.toDisplay(point);
    }

    public String toString() {
        return this.browser.toString();
    }

    @Deprecated
    public void __trackCommand(Command command) {
        this.trackedCommands.put(command.getName(), command);
    }

    public boolean traverse(int traversal) {
        return this.browser.traverse(traversal);
    }

    @Deprecated
    public void __untrackCommand(Command command) {
        this.trackedCommands.remove(command.getName());
    }

    void onCkEditorInitialized() {
        this.browser.addListener(27, event -> {
            FocusEvent focusEvent = new FocusEvent(event);
            for (FocusListener l : this.focusListeners) {
                l.focusLost(focusEvent);
            }
        });
        this.initialized = true;
        for (Runnable command : this.pendingActions) {
            try {
                command.run();
            }
            catch (RuntimeException e) {
                UI.LOG.warning((Throwable)e);
            }
        }
        this.pendingActions.clear();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void registerBrowserFunctions() {
        this.debugLog("registerBrowserFunctions() called");
        new InitFunction(this.browser);
        new SelectionChangedFunction(this.browser);
        new ModifiedFunction(this.browser);
        new FocusLostFunction(this.browser);
        new FocusGainedFunction(this.browser);
        new BrowserFunction(this.browser, "_delegate_log"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    arguments[0] = "HtmlComposer JS log:" + String.valueOf(arguments[0]);
                }
                UI.LOG.debug(Arrays.toString(arguments));
                return null;
            }
        };
        new BrowserFunction(this.browser, "_eclipse_running"){

            public Object function(Object[] arguments) {
                return Boolean.TRUE;
            }
        };
    }

    private class FocusGainedFunction
    extends BrowserFunction {
        public FocusGainedFunction(Browser browser) {
            super(browser, "_delegate_focusGained");
        }

        public Object function(Object[] args) {
            UIThreadRunner.asynExec((Widget)this.getBrowser(), () -> {
                for (FocusListener l : HtmlComposer.this.focusListeners) {
                    l.focusGained(null);
                }
            });
            return null;
        }
    }

    private class FocusLostFunction
    extends BrowserFunction {
        public FocusLostFunction(Browser browser) {
            super(browser, "_delegate_focusLost");
        }

        public Object function(Object[] args) {
            UIThreadRunner.asynExec((Widget)this.getBrowser(), () -> {
                try {
                    for (FocusListener l : HtmlComposer.this.focusListeners) {
                        l.focusLost(null);
                    }
                }
                catch (RuntimeException e) {
                    UI.LOG.warning((Throwable)e);
                }
            });
            return null;
        }
    }

    private class InitFunction
    extends BrowserFunction {
        public InitFunction(Browser browser) {
            super(browser, "_delegate_init");
        }

        public Object function(Object[] arguments) {
            UIThreadRunner.asynExec((Widget)this.getBrowser(), () -> HtmlComposer.this.onCkEditorInitialized());
            return null;
        }
    }

    private class ModifiedFunction
    extends BrowserFunction {
        public ModifiedFunction(Browser browser) {
            super(browser, "_delegate_modified");
        }

        public Object function(Object[] arguments) {
            List<ModifyListener> listeners = HtmlComposer.this.modifyListenerList;
            if (!listeners.isEmpty()) {
                UIThreadRunner.asynExec((Widget)this.getBrowser(), () -> {
                    Event event = new Event();
                    event.widget = this.getBrowser();
                    event.data = this;
                    ModifyEvent modifyEvent = new ModifyEvent(event);
                    for (ModifyListener listener : listeners) {
                        listener.modifyText(modifyEvent);
                    }
                });
            }
            return null;
        }
    }

    private class SelectionChangedFunction
    extends BrowserFunction {
        public SelectionChangedFunction(Browser browser) {
            super(browser, "_delegate_selectionChanged");
        }

        public Object function(Object[] arguments) {
            if (!HtmlComposer.this.selectionListenerList.isEmpty()) {
                UIThreadRunner.asynExec((Widget)this.getBrowser(), () -> {
                    NodeSelectionEvent nodeSelectionEvent = new NodeSelectionEvent(null);
                    for (NodeSelectionChangeListener listener : HtmlComposer.this.selectionListenerList) {
                        listener.selectedNodeChanged(nodeSelectionEvent);
                    }
                });
            }
            return null;
        }
    }
}

