/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.swt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.modelio.platform.ui.plugin.UI;

public class BrowserConfigurator {
    private static final String EDGE_DATA_DIR = "org.eclipse.swt.browser.EdgeDataDir";
    private static final String BROWSER_DIR_PROP = "org.eclipse.swt.browser.EdgeDir";
    private static boolean fallBackNeeded = false;

    public static Browser newBrowser(Composite parent, int style) {
        String osName = System.getProperty("os.name");
        if ((osName.equals("Windows 10") || osName.equals("Windows 11")) && !fallBackNeeded) {
            return BrowserConfigurator.newEdgeBrowser(parent, style);
        }
        return new Browser(parent, style);
    }

    private static Browser newEdgeBrowser(Composite parent, int style) throws SWTError {
        try {
            assert ((style & 0x10000) == 0) : "style contains SWT.WEBKIT";
            return new Browser(parent, 0x40000 | style);
        }
        catch (SWTError e) {
            if (e.code == 2 && e.getMessage().contains("0x8007139f")) {
                UI.LOG.warning("Edge Browser instantiation failed with : %s", new Object[]{e.getMessage()});
                try {
                    Path tempRoot = Path.of(System.getProperty("java.io.tmpdir"), "modelio");
                    Files.createDirectories(tempRoot, new FileAttribute[0]);
                    Path tmpDir = Files.createTempDirectory(tempRoot, "Webview-EDGE-", new FileAttribute[0]);
                    System.setProperty(EDGE_DATA_DIR, tmpDir.toString());
                    tmpDir.toFile().deleteOnExit();
                    UI.LOG.warning("Setting '%s' property to '%s' and try again...", new Object[]{EDGE_DATA_DIR, tmpDir});
                    return new Browser(parent, 0x40000 | style);
                }
                catch (IOException | SWTError e1) {
                    e1.addSuppressed(e);
                    UI.LOG.warning("Edge Browser instantiation failed again with : %s", new Object[]{e1});
                    UI.LOG.warning("Fall back to Internet Explorer...");
                    try {
                        fallBackNeeded = true;
                        Browser oldBrowser = BrowserConfigurator.oldBrowser(parent, style);
                        UI.LOG.debug((Throwable)e);
                        return oldBrowser;
                    }
                    catch (SWTError e2) {
                        e2.addSuppressed(e1);
                        UI.LOG.error((Throwable)e);
                        throw e2;
                    }
                }
            }
            throw e;
        }
    }

    @Deprecated
    public static Browser oldBrowser(Composite parent, int style) {
        return new Browser(parent, style & 0xFFFBFFFF);
    }
}

