/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.swt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class PngTransfer
extends ByteArrayTransfer {
    private static final String IMAGE_PNG = "image/png";
    private static final int ID = PngTransfer.registerType((String)"image/png");
    private static PngTransfer _instance = new PngTransfer();

    private PngTransfer() {
    }

    public static PngTransfer getInstance() {
        return _instance;
    }

    protected String[] getTypeNames() {
        return new String[]{IMAGE_PNG};
    }

    protected int[] getTypeIds() {
        return new int[]{ID};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof ImageData)) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            ImageData image = (ImageData)object;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    ImageLoader imgLoader = new ImageLoader();
                    imgLoader.data = new ImageData[]{image};
                    imgLoader.save((OutputStream)out, 5);
                    byte[] buffer = out.toByteArray();
                    out.close();
                    super.javaToNative((Object)buffer, transferData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(buffer);){
                    return new ImageData((InputStream)in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }
}

