/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.swt.imagesselector;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.modelio.platform.ui.plugin.UI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageLibrary {
    private List<String> categories = new ArrayList<String>();
    private HashMap<String, String> labels = new HashMap();
    private String name = "";
    private HashMap<Object, List<String>> images = new HashMap();
    private URI repository;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ImageLibrary(URI repository) {
        this.repository = repository;
        new CatalogParser().loadLibrary(this, repository);
    }

    private void addImage(String category, String imageFilename, String imageLabel) {
        if (!this.categories.contains(category)) {
            this.categories.add(category);
            this.images.put(category, new ArrayList());
        }
        this.images.get(category).add(imageFilename);
        this.labels.put(imageFilename, imageLabel);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<String> getImages(String category) {
        return this.images.getOrDefault(category, Collections.EMPTY_LIST);
    }

    public String getLabel(String imageFile) {
        return this.labels.getOrDefault(imageFile, imageFile);
    }

    public URL getImage(String image) {
        try {
            return new URL(this.repository.toString() + "/" + image);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getImageThumbnail(String image) {
        try {
            return new URL(this.repository.toString() + "/" + image);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static class CatalogParser {
        private CatalogParser() {
        }

        public void loadLibrary(ImageLibrary imageLibrary, URI repository) {
            try {
                URL catalogURL = new URL(repository.toString() + "/catalog.xml");
                Throwable throwable = null;
                Object var5_8 = null;
                try (InputStream xmlStream = catalogURL.openConnection().getInputStream();){
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document xmlDoc = db.parse(xmlStream);
                    Element rootElement = xmlDoc.getDocumentElement();
                    this.parseLibrary(imageLibrary, rootElement);
                    xmlStream.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                UI.LOG.error((Throwable)e);
            }
        }

        private void parseLibrary(ImageLibrary imageLibrary, Element rootElement) {
            imageLibrary.setName(rootElement.getAttribute("name"));
            NodeList childNodes = rootElement.getElementsByTagName("category");
            int nNodes = childNodes.getLength();
            int i = 0;
            while (i < nNodes) {
                Element categoryElement = (Element)childNodes.item(i);
                List<String> images = this.parseCategory(categoryElement);
                int j = 0;
                while (j < images.size()) {
                    imageLibrary.addImage(categoryElement.getAttribute("name"), images.get(j), images.get(j + 1));
                    j += 2;
                }
                ++i;
            }
        }

        private List<String> parseCategory(Element categoryElement) {
            ArrayList<String> filenames = new ArrayList<String>();
            NodeList childNodes = categoryElement.getElementsByTagName("image");
            int nNodes = childNodes.getLength();
            int i = 0;
            while (i < nNodes) {
                Element imageElement = (Element)childNodes.item(i);
                String filename = imageElement.getAttribute("file");
                filenames.add(filename);
                filenames.add(this.parseLabel(imageElement));
                ++i;
            }
            return filenames;
        }

        private String parseLabel(Element imageElement) {
            String label = null;
            String defaultLabel = imageElement.getAttribute("file");
            String targetLang = Locale.getDefault().getLanguage();
            NodeList childNodes = imageElement.getElementsByTagName("label");
            int nNodes = childNodes.getLength();
            int i = 0;
            while (i < nNodes) {
                Element labelElement = (Element)childNodes.item(i);
                String lang = labelElement.getAttribute("lang");
                if (Objects.equals(targetLang, lang)) {
                    label = labelElement.getTextContent().trim();
                }
                if (Objects.equals(targetLang, "default")) {
                    defaultLabel = labelElement.getTextContent().trim();
                }
                ++i;
            }
            return label != null ? label : defaultLabel;
        }
    }
}

