/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.platform.ui.swt.imagesselector;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.modelio.platform.ui.FontBuilder;
import org.modelio.platform.ui.UIImages;
import org.modelio.platform.ui.UIThreadRunner;
import org.modelio.platform.ui.dialog.ModelioDialog;
import org.modelio.platform.ui.plugin.UI;
import org.modelio.platform.ui.swt.imagesselector.ImageLibrary;

public class ImageSelectionDialog
extends ModelioDialog {
    private Gallery gallery;
    private final ImageLibrary imagesLibrary;
    private LocalResourceManager rm;
    private Text searchText;
    private static ImageRegistry thumbnailsCache = new ImageRegistry();
    private Font galleryFont;

    public ImageSelectionDialog(Shell parentShell, ImageLibrary imagesLibrary) {
        super(parentShell);
        this.imagesLibrary = imagesLibrary;
    }

    @Override
    protected void addButtonsInButtonBar(Composite parent) {
        this.addDefaultButtons(parent);
    }

    @Override
    protected Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.searchText = new Text(composite, 2048);
        this.searchText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.searchText.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
            } else if (e.detail == 2) {
                e.doit = false;
            }
        });
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ImageSelectionDialog.this.onFilterItems(ImageSelectionDialog.this.searchText.getText());
            }
        });
        Label searchImage = new Label(composite, 0);
        searchImage.setImage(UIImages.SEARCH);
        this.rm = new LocalResourceManager(JFaceResources.getResources());
        this.gallery = new Gallery(composite, 0x10000200);
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer();
        gr.setMinMargin(2);
        gr.setAutoMargin(false);
        gr.setAnimation(false);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        ir.setShowLabels(true);
        this.galleryFont = new FontBuilder().from(this.gallery.getFont()).scale(0.8f).withAllocator((ResourceManager)this.rm).build();
        ir.setFont(this.galleryFont);
        this.gallery.setFont(this.galleryFont);
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.show(null);
        this.gallery.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    @Override
    protected void init() {
        this.setTitle(UI.I18N.getString("ImageSelectionDialog.title"));
        this.setMessage(UI.I18N.getMessage("ImageSelectionDialog.subtitle", new Object[]{this.imagesLibrary.getName()}));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UI.I18N.getString("ImageSelectionDialog.title"));
    }

    public URL getSelectedItem() {
        if (this.gallery.getSelection().length == 1) {
            return this.imagesLibrary.getImage((String)this.gallery.getSelection()[0].getData());
        }
        return null;
    }

    public void onFilterItems(String filter) {
        if (!filter.equals(this.gallery.getData("filter"))) {
            this.gallery.setData("filter", (Object)filter);
            this.gallery.removeAll();
            this.show(filter);
            this.gallery.redraw();
        }
    }

    private void show(String filter) {
        ArrayList itemList = new ArrayList();
        UIThreadRunner.asynExec((Widget)this.gallery, () -> {
            for (String category : this.imagesLibrary.getCategories()) {
                GalleryItem group = new GalleryItem(this.gallery, 0);
                group.setText(category);
                group.setExpanded(true);
                for (String imageId : this.imagesLibrary.getImages(category)) {
                    String label = this.imagesLibrary.getLabel(imageId);
                    if (filter != null && !"".equals(filter) && (label.toLowerCase() == null || !label.contains(filter.toLowerCase()))) continue;
                    GalleryItem item = new GalleryItem(group, 0);
                    URL url = this.imagesLibrary.getImageThumbnail(imageId);
                    Image thumbnailImage = thumbnailsCache.get(url.toString());
                    if (thumbnailImage == null) {
                        thumbnailImage = ImageDescriptor.createFromURL((URL)url).createImage();
                        thumbnailsCache.put(url.toString(), thumbnailImage);
                    }
                    item.setImage(thumbnailImage);
                    item.setText(label);
                    item.setData((Object)imageId);
                }
                itemList.add(group);
            }
            this.gallery.update();
        });
    }

    public boolean close() {
        return super.close();
    }

    @Override
    protected Point getInitialSize() {
        return new Point(550, 500);
    }
}

