/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.version;

import org.modelio.vbasic.version.Version;

public class ModelioVersionGuesser {
    public static Version guessFromStandardMmVersion(Version v) throws IllegalArgumentException, UnsupportedOperationException {
        if (v.compareTo(new Version(2, 1, 0)) >= 0) {
            throw new UnsupportedOperationException(v.toString());
        }
        if (v.compareTo(new Version(2, 0, 0)) >= 0) {
            return new Version(3, 6, 0);
        }
        if (v.compareTo(new Version(1, 1, 0)) >= 0) {
            return new Version(3, 5, 0);
        }
        int mmv = v.getBuildVersion();
        if (mmv >= 9025) {
            return new Version(3, 4, 1);
        }
        if (mmv >= 9023) {
            return new Version(3, 3, 1);
        }
        if (mmv >= 9021) {
            return new Version(3, 2, 1);
        }
        if (mmv >= 9018) {
            return new Version(3, 1, 2);
        }
        if (mmv >= 9017) {
            return new Version(3, 0, 1);
        }
        if (mmv >= 9000) {
            return new Version(3, 0, 0);
        }
        if (mmv >= 8020) {
            return new Version(2, 2, 0);
        }
        if (mmv >= 8007) {
            return new Version(2, 1, 0);
        }
        if (mmv >= 8000) {
            return new Version(2, 0, 0);
        }
        if (mmv >= 7008) {
            return new Version(1, 2, 0);
        }
        if (mmv >= 7005) {
            return new Version(1, 1, 0);
        }
        if (mmv >= 7000) {
            return new Version(1, 0, 0);
        }
        throw new IllegalArgumentException(v.toString());
    }
}

